/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class StarterBundleItem
extends Item {
    public static List<Supplier<? extends Item>> STARTER_ITEMS = List.of(DoggyItems.DOGGY_CHARM, DoggyItems.WHISTLE, DoggyItems.RADIO_COLLAR, DoggyItems.CANINE_TRACKER, () -> Items.STICK, () -> Items.BONE);

    public StarterBundleItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        Inventory inv = player.getInventory();
        NonNullList items = inv.items;
        boolean hasEnoughSpace = false;
        int freeSlot = 0;
        for (ItemStack item : items) {
            if (item.isEmpty()) {
                ++freeSlot;
            }
            if (freeSlot < STARTER_ITEMS.size()) continue;
            hasEnoughSpace = true;
            break;
        }
        if (!hasEnoughSpace) {
            player.displayClientMessage((Component)Component.translatable((String)"item.doggytalents.starter_bundle.fail").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.success((Object)stack);
        }
        for (Supplier<? extends Item> regItem : STARTER_ITEMS) {
            ItemStack starterStack = new ItemStack((ItemLike)regItem.get());
            inv.add(starterStack);
        }
        player.setItemInHand(hand, ItemStack.EMPTY);
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = this.getDescriptionId(stack) + ".description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
        for (Supplier<? extends Item> item : STARTER_ITEMS) {
            MutableComponent c1 = Component.translatable((String)"item.doggytalents.starter_bundle.contains", (Object[])new Object[]{1, Component.translatable((String)item.get().getDescriptionId())});
            components.add((Component)c1);
        }
    }
}

