/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.DogLevel;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.RandomUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TreatItem
extends Item
implements IDogItem {
    private final int maxLevel;
    private final DogLevel.Type type;

    public TreatItem(int maxLevel, DogLevel.Type typeIn, Item.Properties properties) {
        super(properties);
        this.maxLevel = maxLevel;
        this.type = typeIn;
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!dog.isTame() || !dog.canInteract((LivingEntity)playerIn)) {
            return InteractionResult.FAIL;
        }
        if (this.handleKamiBypass(dog, worldIn, playerIn, handIn).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        return this.handleTreatTrain(dog, worldIn, playerIn, handIn);
    }

    private InteractionResult handleKamiBypass(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (this.type != DogLevel.Type.KAMI) {
            return InteractionResult.PASS;
        }
        if (!playerIn.isCreative()) {
            return InteractionResult.PASS;
        }
        DogLevel dog_level = dog.getDogLevel();
        if (dog_level.canIncrease(DogLevel.Type.KAMI)) {
            return InteractionResult.PASS;
        }
        if (!(dog instanceof Dog)) {
            return InteractionResult.PASS;
        }
        Dog actual_dog = (Dog)dog;
        if (!dog.level().isClientSide) {
            actual_dog.setLevel(DogLevel.kamiReady());
            playerIn.getCooldowns().addCooldown((Item)this, 40);
        }
        this.playKamiBypassEffect(actual_dog);
        return InteractionResult.SUCCESS;
    }

    private void playKamiBypassEffect(Dog dog) {
        Level level = dog.level();
        if (!level.isClientSide) {
            return;
        }
        Vec3 dog_pos = dog.position();
        level.playLocalSound(dog_pos.x, dog_pos.y, dog_pos.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f, false);
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, dog_pos.x, dog_pos.y, dog_pos.z, 1.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, dog_pos.x, dog_pos.y, dog_pos.z, 1.0, 0.0, 0.0);
        for (int i = 0; i <= 30; ++i) {
            float f1 = RandomUtil.nextFloatRemapped(dog.getRandom()) * dog.getBbWidth() * 1.0f;
            float f2 = RandomUtil.nextFloatRemapped(dog.getRandom()) * dog.getBbWidth() * 1.0f;
            double dx = level.getRandom().nextGaussian() * 0.3;
            double dy = level.getRandom().nextGaussian() * 0.3;
            double dz = level.getRandom().nextGaussian() * 0.3;
            dog.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, dog.getX() + (double)f1, dog.getY(), dog.getZ() + (double)f2, dx, dy, dz);
        }
    }

    private InteractionResult handleTreatTrain(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (dog.getAge() < 0) {
            this.treatFailPrompt(dog, worldIn, playerIn, (Component)Component.translatable((String)("treat." + this.type.getName() + ".too_young")));
            return InteractionResult.CONSUME;
        }
        DogLevel dogLevel = dog.getDogLevel();
        if (!dogLevel.canIncrease(this.type)) {
            this.treatFailPrompt(dog, worldIn, playerIn, (Component)Component.translatable((String)("treat." + this.type.getName() + ".low_level")));
            return InteractionResult.CONSUME;
        }
        if (dogLevel.getLevel(this.type) >= this.maxLevel) {
            this.treatFailPrompt(dog, worldIn, playerIn, (Component)Component.translatable((String)("treat." + this.type.getName() + ".max_level")));
            return InteractionResult.CONSUME;
        }
        if (!playerIn.level().isClientSide) {
            if (!playerIn.getAbilities().instabuild) {
                playerIn.getItemInHand(handIn).shrink(1);
            }
            dog.increaseLevel(this.type);
            dog.setOrderedToSit(true);
        }
        this.treatSuccessPrompt(dog, worldIn, playerIn);
        return InteractionResult.SUCCESS;
    }

    private void treatFailPrompt(AbstractDog dog, Level worldIn, Player playerIn, Component msg) {
        if (!worldIn.isClientSide) {
            worldIn.broadcastEntityEvent((Entity)dog, (byte)6);
            playerIn.sendSystemMessage(msg);
        }
    }

    private void treatSuccessPrompt(AbstractDog dog, Level worldIn, Player playerIn) {
        if (!worldIn.isClientSide) {
            worldIn.broadcastEntityEvent((Entity)dog, (byte)7);
            playerIn.sendSystemMessage((Component)Component.translatable((String)("treat." + this.type.getName() + ".level_up")));
        }
    }
}

