/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.general;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import snownee.jade.addon.general.TargetModifierLoader;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import top.theillusivec4.curios.api.CuriosApi;

public class GeneralPlugin
implements IWailaPlugin {
    public static final String ID = "jadeaddons";
    public static final ResourceLocation EQUIPMENT_REQUIREMENT = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons", (String)"equipment_requirement");
    public static BiPredicate<Player, TagKey<Item>> EQUIPMENT_CHECK_PREDICATE = (player, tag) -> player.getMainHandItem().is(tag) || player.getOffhandItem().is(tag) || player.getItemBySlot(EquipmentSlot.HEAD).is(tag);
    public TagKey<Item> requirementTag;

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(EQUIPMENT_REQUIREMENT, "", $ -> ResourceLocation.read((String)$).isSuccess());
        registration.addConfigListener(EQUIPMENT_REQUIREMENT, id -> this.refreshTag((ResourceLocation)id, $ -> {
            this.requirementTag = $;
        }));
        registration.addRayTraceCallback(10000, (hitResult, accessor, originalAccessor) -> {
            if (accessor != null) {
                Player player = accessor.getPlayer();
                if (this.requirementTag != null && !EQUIPMENT_CHECK_PREDICATE.test(player, this.requirementTag)) {
                    return null;
                }
            }
            return accessor;
        });
        if (ModList.get().isLoaded("curios")) {
            EQUIPMENT_CHECK_PREDICATE = EQUIPMENT_CHECK_PREDICATE.or((player, tag) -> CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(inventory -> inventory.findFirstCurio(itemStack -> itemStack.is(tag))).isPresent());
        }
        TargetModifierLoader loader = new TargetModifierLoader();
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
                this.refreshTags();
                loader.reload();
            }
        });
        registration.addRayTraceCallback((JadeRayTraceCallback)loader);
        registration.addTooltipCollectedCallback((JadeTooltipCollectedCallback)loader);
        registration.markAsClientFeature(EQUIPMENT_REQUIREMENT);
    }

    private void refreshTags() {
        this.refreshTag(EQUIPMENT_REQUIREMENT, $ -> {
            this.requirementTag = $;
        });
    }

    private void refreshTag(ResourceLocation id, Consumer<TagKey<Item>> setter) {
        String s = IWailaConfig.get().getPlugin().getString(id);
        if (s.isBlank()) {
            setter.accept(null);
        } else {
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)s);
            if (resourceLocation != null) {
                setter.accept((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation));
            }
        }
    }
}

