/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.drawables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class LabelDrawable
implements IDrawable {
    public final Component text;
    private final Font font;
    public int color = -1;
    public int maxWidth = -1;
    public boolean shadow = true;
    private LabelAlignment align = LabelAlignment.CENTER;
    private List<FormattedLine> formattedLines = null;

    public LabelDrawable(Component text) {
        this.text = text;
        this.font = Minecraft.getInstance().font;
    }

    public Rect2i getBounds() {
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        for (FormattedLine formattedLine : this.getLines()) {
            top = Math.min(top, (int)formattedLine.y);
            left = Math.min(left, (int)formattedLine.x);
            bottom = Math.max(bottom, (int)(formattedLine.y + (float)formattedLine.height));
            right = Math.max(right, (int)(formattedLine.x + (float)formattedLine.width));
        }
        int width = right - left;
        int height = bottom - top;
        return new Rect2i(left, top, width, height);
    }

    public int getX() {
        int left = Integer.MAX_VALUE;
        for (FormattedLine formattedLine : this.getLines()) {
            left = Math.min(left, (int)formattedLine.x);
        }
        return left;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        for (FormattedLine line : this.getLines()) {
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, line.text, (int)line.x + xOffset, (int)line.y + yOffset, this.color, this.shadow);
        }
    }

    public int getWidth() {
        return this.getBounds().getWidth();
    }

    public int getHeight() {
        return this.getBounds().getHeight();
    }

    public LabelDrawable bodyColor() {
        this.color = 0x7E7E7E;
        return this;
    }

    public LabelDrawable alignLeft() {
        this.align = LabelAlignment.LEFT;
        return this;
    }

    public LabelDrawable alignRight() {
        this.align = LabelAlignment.RIGHT;
        return this;
    }

    public LabelDrawable noShadow() {
        this.shadow = false;
        return this;
    }

    public LabelDrawable bodyText() {
        this.noShadow();
        this.bodyColor();
        return this;
    }

    private float getAlignedX(int width) {
        return switch (this.align.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.0f;
            case 1 -> (float)(-width) / 2.0f;
            case 2 -> -width;
        };
    }

    public LabelDrawable maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    private List<FormattedLine> getLines() {
        if (this.formattedLines != null) {
            return this.formattedLines;
        }
        if (this.maxWidth == -1) {
            FormattedCharSequence formattedText = this.text.getVisualOrderText();
            int width = this.font.width(formattedText);
            float f = this.getAlignedX(width);
            Objects.requireNonNull(this.font);
            this.formattedLines = List.of(new FormattedLine(formattedText, f, 0.0f, width, 9));
        } else {
            List splitLines = this.font.split((FormattedText)this.text, this.maxWidth);
            ArrayList<FormattedLine> formattedLines = new ArrayList<FormattedLine>(splitLines.size());
            for (int i = 0; i < splitLines.size(); ++i) {
                FormattedCharSequence splitLine = (FormattedCharSequence)splitLines.get(i);
                int width = this.font.width(splitLine);
                float f = this.getAlignedX(width);
                Objects.requireNonNull(this.font);
                float f2 = i * 9;
                Objects.requireNonNull(this.font);
                formattedLines.add(new FormattedLine(splitLine, f, f2, width, 9));
            }
            this.formattedLines = formattedLines;
        }
        return this.formattedLines;
    }

    private static enum LabelAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    private record FormattedLine(FormattedCharSequence text, float x, float y, int width, int height) {
    }
}

