/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories_compat.curios.pond.CurioInventoryCapabilityExtension;
import io.wispforest.accessories_compat.curios.pond.CurioInventoryExtension;
import io.wispforest.accessories_compat.curios.wrapper.AccessoriesBasedStackHandler;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import io.wispforest.accessories_compat.utils.ImmutableDelegatingMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.capability.CurioInventory;

@Mixin(value={CurioInventory.class})
public abstract class CurioInventoryMixin
implements CurioInventoryExtension {
    @Shadow
    boolean markDeserialized;
    @Shadow
    CompoundTag deserialized;
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    @Nullable
    private AccessoriesCapabilityImpl capability = null;
    @Unique
    @Nullable
    private AccessoriesHolderImpl holder = null;

    @Override
    public List<ItemStack> getInvalidStacks() {
        AccessoriesHolderImpl holder;
        if (this.capability != null && (holder = this.holder()) != null) {
            return holder.invalidStacks;
        }
        return List.of();
    }

    @Nullable
    private AccessoriesHolderImpl holder() {
        if (this.capability != null) {
            if (this.holder == null) {
                this.holder = (AccessoriesHolderImpl)this.capability.getHolder();
            }
            return this.holder;
        }
        return null;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void runInitWithAccessoriesInMind(ICuriosItemHandler curiosItemHandler, CallbackInfo ci) {
        ci.cancel();
        if (!(curiosItemHandler instanceof CurioInventoryCapabilityExtension)) {
            LOGGER.error("Unable to init a given CurioInventory due to given ICuriosItemHandler not being instance of CurioInventoryCapability!");
            return;
        }
        CurioInventoryCapabilityExtension ext = (CurioInventoryCapabilityExtension)curiosItemHandler;
        this.capability = ext.capability();
        this.holder = null;
        if (this.markDeserialized) {
            this.markDeserialized = false;
            if (this.deserialized.getBoolean("AccessoriesEncoded") || this.deserialized.isEmpty()) {
                return;
            }
            CurioInventoryMixin.readData(this.capability.entity(), (AccessoriesCapability)this.capability, this.holder(), this.deserialized.getList("Curios", 10));
            this.deserialized = new CompoundTag();
        }
    }

    @Unique
    private static void readData(LivingEntity livingEntity, AccessoriesCapability capability, AccessoriesHolderImpl holder, ListTag data) {
        for (int i = 0; i < data.size(); ++i) {
            CompoundTag tag = data.getCompound(i);
            String curiosId = tag.getString("Identifier");
            SlotType slotType = SlotTypeLoader.getSlotType((Level)livingEntity.level(), (String)CuriosConversionUtils.slotConvertToA(curiosId));
            AccessoriesContainer container = slotType != null ? capability.getContainer(slotType) : null;
            holder.invalidStacks.addAll(CurioInventoryMixin.deserializeNBT_StackHandler(livingEntity, container, tag.getCompound("StacksHandler")));
        }
        List invalidStacks = holder.invalidStacks;
        for (SlotEntryReference entryRef : capability.getAllEquipped()) {
            SlotReference reference = entryRef.reference();
            SlotType slotType = reference.type();
            if (AccessoriesAPI.getPredicateResults((Set)slotType.validators(), (Level)reference.entity().level(), (LivingEntity)livingEntity, (SlotType)slotType, (int)0, (ItemStack)entryRef.stack())) continue;
            invalidStacks.add(entryRef.stack().copy());
            entryRef.reference().setStack(ItemStack.EMPTY);
        }
    }

    @Unique
    private static List<ItemStack> deserializeNBT_StackHandler(LivingEntity livingEntity, @Nullable AccessoriesContainer container, CompoundTag nbt) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        if (nbt.contains("Stacks")) {
            dropped.addAll(CurioInventoryMixin.deserializeNBT_Stacks(livingEntity, container, AccessoriesContainer::getAccessories, nbt.getCompound("Stacks")));
        }
        if (nbt.contains("Cosmetics")) {
            dropped.addAll(CurioInventoryMixin.deserializeNBT_Stacks(livingEntity, container, AccessoriesContainer::getCosmeticAccessories, nbt.getCompound("Cosmetics")));
        }
        return dropped;
    }

    @Unique
    private static List<ItemStack> deserializeNBT_Stacks(LivingEntity livingEntity, @Nullable AccessoriesContainer container, Function<AccessoriesContainer, Container> containerFunc, CompoundTag nbt) {
        List<ItemStack> list = nbt.getList("Items", 10).stream().map(tagEntry -> {
            CompoundTag compoundTag;
            return ItemStack.parseOptional((HolderLookup.Provider)livingEntity.registryAccess(), (CompoundTag)(tagEntry instanceof CompoundTag ? (compoundTag = (CompoundTag)tagEntry) : new CompoundTag()));
        }).toList();
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        if (container != null) {
            Container accessories = containerFunc.apply(container);
            for (ItemStack stack : list) {
                boolean consumedStack = false;
                for (int i = 0; i < accessories.getContainerSize() && !consumedStack; ++i) {
                    ItemStack currentStack = accessories.getItem(i);
                    if (!currentStack.isEmpty()) continue;
                    accessories.setItem(i, stack.copy());
                    consumedStack = true;
                }
                if (consumedStack) continue;
                dropped.add(stack.copy());
            }
        } else {
            dropped.addAll(list);
        }
        return dropped;
    }

    @Inject(method={"asMap"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getMapFromAccessoriesHolder(CallbackInfoReturnable<Map<String, ICurioStacksHandler>> cir) {
        if (this.capability == null) {
            cir.setReturnValue(Map.of());
        } else {
            AccessoriesHolderImpl holder = this.holder();
            if (holder != null) {
                cir.setReturnValue(new ImmutableDelegatingMap<String, ICurioStacksHandler, AccessoriesContainer>("containers", String.class, ICurioStacksHandler.class, holder.getSlotContainers(), CuriosConversionUtils::slotConvertToC, CuriosConversionUtils::slotConvertToA, AccessoriesBasedStackHandler::new, handler -> {
                    AccessoriesContainerImpl accessoriesContainerImpl;
                    if (!(handler instanceof AccessoriesBasedStackHandler)) return null;
                    AccessoriesBasedStackHandler $b$0 = (AccessoriesBasedStackHandler)handler;
                    try {
                        AccessoriesContainerImpl patt1$temp;
                        AccessoriesContainerImpl container;
                        accessoriesContainerImpl = container = (patt1$temp = $b$0.container());
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    return accessoriesContainerImpl;
                }));
            }
        }
    }

    @Inject(method={"replace"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void replaceWithNoop(Map<String, ICurioStacksHandler> curios, CallbackInfo ci) {
        ci.cancel();
    }

    @WrapOperation(method={"serializeNBT(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="FIELD", target="Ltop/theillusivec4/curios/common/capability/CurioInventory;curios:Ljava/util/Map;")})
    private Map<String, ICurioStacksHandler> useMethodInsteadOfField(CurioInventory instance, Operation<Map<String, ICurioStacksHandler>> original) {
        return instance.asMap();
    }

    @ModifyReturnValue(method={"serializeNBT(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    private CompoundTag addFlagForEncodedByCompat(CompoundTag original) {
        original.putBoolean("AccessoriesEncoded", true);
        return original;
    }
}

