/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import com.google.common.collect.ImmutableMap;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.data.AccessoriesBaseData;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories_compat.curios.pond.SlotContextExtension;
import io.wispforest.accessories_compat.curios.wrapper.AccessoriesBasedCurioSlot;
import io.wispforest.accessories_compat.curios.wrapper.AccessoryFromCurio;
import io.wispforest.accessories_compat.curios.wrapper.CurioFromAccessory;
import io.wispforest.accessories_compat.utils.ImmutableDelegatingMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.common.capability.ItemizedCurioCapability;
import top.theillusivec4.curios.common.slottype.SlotType;

public class CuriosConversionUtils {
    public static ICapabilityProvider<ItemStack, Void, ICurio> BASE_PROVIDER = null;
    public static final Map<String, SlotType.Builder> CURRENT_SLOT_BUILDERS = new HashMap<String, SlotType.Builder>();
    public static final Map<EntityType<?>, ImmutableMap.Builder<String, ISlotType>> CURRENT_ENTITY_BINDINGS = new HashMap();

    public static SlotContext objectsConvertToC(SlotReference slotReference) {
        return SlotContextExtension.from(slotReference);
    }

    public static SlotReference convertToA(SlotContext slotContext) {
        SlotReference ref = SlotContextExtension.from(slotContext).slotReference();
        if (ref == null) {
            ref = SlotReference.of((LivingEntity)slotContext.entity(), (String)CuriosConversionUtils.slotConvertToA(slotContext.identifier()), (int)slotContext.index());
        }
        return ref;
    }

    public static ICurio.DropRule dropRuleConvertToC(DropRule dropRule) {
        return switch (dropRule) {
            default -> throw new MatchException(null, null);
            case DropRule.KEEP -> ICurio.DropRule.ALWAYS_KEEP;
            case DropRule.DROP -> ICurio.DropRule.ALWAYS_DROP;
            case DropRule.DESTROY -> ICurio.DropRule.DESTROY;
            case DropRule.DEFAULT -> ICurio.DropRule.DEFAULT;
        };
    }

    public static DropRule dropRuleConvertToA(ICurio.DropRule dropRule) {
        return switch (dropRule) {
            default -> throw new MatchException(null, null);
            case ICurio.DropRule.ALWAYS_KEEP -> DropRule.KEEP;
            case ICurio.DropRule.ALWAYS_DROP -> DropRule.DROP;
            case ICurio.DropRule.DESTROY -> DropRule.DESTROY;
            case ICurio.DropRule.DEFAULT -> DropRule.DEFAULT;
        };
    }

    public static String slotConvertToA(String curiosType) {
        return switch (curiosType) {
            case "curio" -> "any";
            case "head" -> "hat";
            case "body" -> "cape";
            case "bracelet" -> "wrist";
            case "hands" -> "hand";
            case "feet" -> "shoes";
            default -> curiosType;
        };
    }

    public static String slotConvertToC(String accessoriesType) {
        return switch (accessoriesType) {
            case "any" -> "curio";
            case "hat" -> "head";
            case "cape" -> "body";
            case "wrist" -> "bracelet";
            case "hand" -> "hands";
            case "shoes" -> "feet";
            default -> accessoriesType;
        };
    }

    public static ResourceLocation predicateIdConvertToC(ResourceLocation accessoryPredicateId) {
        if (accessoryPredicateId.equals((Object)AccessoriesBaseData.ALL_PREDICATE_ID)) {
            return ResourceLocation.parse((String)"curios:all");
        }
        if (accessoryPredicateId.equals((Object)AccessoriesBaseData.NONE_PREDICATE_ID)) {
            return ResourceLocation.parse((String)"curios:none");
        }
        if (accessoryPredicateId.equals((Object)AccessoriesBaseData.TAG_PREDICATE_ID)) {
            return ResourceLocation.parse((String)"curios:tag");
        }
        return accessoryPredicateId;
    }

    public static ResourceLocation convertToA(ResourceLocation curiosPredicateId) {
        return switch (curiosPredicateId.toString()) {
            case "curios:all" -> AccessoriesBaseData.ALL_PREDICATE_ID;
            case "curios:none" -> AccessoriesBaseData.NONE_PREDICATE_ID;
            case "curios:tag" -> AccessoriesBaseData.TAG_PREDICATE_ID;
            default -> curiosPredicateId;
        };
    }

    public static Accessory curioConvertToA(ICurioItem curioItem) {
        return new AccessoryFromCurio(stack -> new ItemizedCurioCapability(curioItem, stack));
    }

    public static Accessory curioConvertToA(ICapabilityProvider<ItemStack, Void, ICurio> icurioProvider) {
        return new AccessoryFromCurio(stack -> (ICurio)icurioProvider.getCapability(stack, null));
    }

    @Nullable
    public static ICurio accessoryConvertToC(Accessory accessory, ItemStack stack) {
        if (accessory instanceof AccessoryFromCurio) {
            AccessoryFromCurio accessoryFromCurio = (AccessoryFromCurio)accessory;
            return accessoryFromCurio.iCurio(stack).orElse(null);
        }
        return new ItemizedCurioCapability((ICurioItem)new CurioFromAccessory(accessory), stack);
    }

    public static Map<String, ISlotType> slotTypesConvertToC(@Nullable Map<String, SlotType> slots) {
        if (slots == null) {
            return Map.of();
        }
        return new ImmutableDelegatingMap<String, ISlotType, SlotType>("slot_types", String.class, ISlotType.class, slots, CuriosConversionUtils::slotConvertToC, CuriosConversionUtils::slotConvertToA, AccessoriesBasedCurioSlot::new, iSlotType -> {
            SlotType slotType;
            if (!(iSlotType instanceof AccessoriesBasedCurioSlot)) return null;
            AccessoriesBasedCurioSlot $b$0 = (AccessoriesBasedCurioSlot)iSlotType;
            try {
                SlotType patt1$temp;
                SlotType slotType2;
                slotType = slotType2 = (patt1$temp = $b$0.slotType());
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return slotType;
        });
    }

    public static <T> Map<String, T> objectsConvertToC(Class<T> clazz, @Nullable Map<String, SlotType> slots, Function<SlotType, T> conversionFunc, BiPredicate<SlotType, T> finderFunc) {
        if (slots == null) {
            return Map.of();
        }
        return new ImmutableDelegatingMap<String, Object, SlotType>("slot_types", String.class, clazz, slots, CuriosConversionUtils::slotConvertToC, CuriosConversionUtils::slotConvertToA, conversionFunc, t -> {
            for (SlotType value : slots.values()) {
                if (!finderFunc.test(value, t)) continue;
                return value;
            }
            return null;
        });
    }

    public static net.fabricmc.fabric.api.util.TriState convertToFabric(@NotNull TriState triState) {
        return switch (triState) {
            default -> throw new MatchException(null, null);
            case TriState.FALSE -> net.fabricmc.fabric.api.util.TriState.FALSE;
            case TriState.TRUE -> net.fabricmc.fabric.api.util.TriState.TRUE;
            case TriState.DEFAULT -> net.fabricmc.fabric.api.util.TriState.DEFAULT;
        };
    }

    public static TriState convertToNeo(@NotNull net.fabricmc.fabric.api.util.TriState triState) {
        return switch (triState) {
            default -> throw new MatchException(null, null);
            case net.fabricmc.fabric.api.util.TriState.FALSE -> TriState.FALSE;
            case net.fabricmc.fabric.api.util.TriState.TRUE -> TriState.TRUE;
            case net.fabricmc.fabric.api.util.TriState.DEFAULT -> TriState.DEFAULT;
        };
    }
}

