/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.datafixers.util.Function3;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories_compat.trinkets.wrapper.AccessoryFromTrinket;
import io.wispforest.accessories_compat.trinkets.wrapper.EmptyTrinketComponent;
import io.wispforest.accessories_compat.trinkets.wrapper.SafeSlotBasedPredicate;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketFromAccessory;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedTrinketComponent;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedTrinketInventory;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrinketsApi.class}, remap=false)
public abstract class TrinketsAPIMixin {
    @Shadow(remap=false)
    @Final
    private static Map<Item, Trinket> TRINKETS;
    @Shadow(remap=false)
    @Final
    @Mutable
    private static Trinket DEFAULT_TRINKET;

    @Inject(method={"registerTrinket"}, at={@At(value="TAIL")}, remap=false)
    private static void registerTrinketAsAccessory(Item item, Trinket trinket, CallbackInfo ci) {
        AccessoriesAPI.registerAccessory((Item)item, (Accessory)new AccessoryFromTrinket(trinket));
    }

    @Inject(method={"getTrinket"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void getAccessoryAsTrinket(Item item, CallbackInfoReturnable<Trinket> cir) {
        Accessory accessory;
        if (!TRINKETS.containsKey(item) && (accessory = AccessoriesAPI.getAccessory((Item)item)) != null) {
            cir.setReturnValue((Object)new TrinketFromAccessory(accessory));
        }
    }

    @Overwrite(remap=false)
    public static Optional<TrinketComponent> getTrinketComponent(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return Optional.empty();
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)livingEntity);
        return Optional.of(capability != null ? new WrappedTrinketComponent(livingEntity) : new EmptyTrinketComponent(livingEntity));
    }

    @Overwrite(remap=false)
    public static void onTrinketBroken(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        AccessoriesAPI.breakStack((SlotReference)reference);
    }

    @Inject(method={"registerTrinketPredicate"}, at={@At(value="HEAD")}, remap=false)
    private static void registerTrinketPredicateWithinAccessories(ResourceLocation id, Function3<ItemStack, dev.emi.trinkets.api.SlotReference, LivingEntity, TriState> predicate, CallbackInfo ci, @Local(argsOnly=true) LocalRef<Function3<ItemStack, dev.emi.trinkets.api.SlotReference, LivingEntity, TriState>> predicateRef) {
        if (id.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"trinkets", (String)"relevant"))) {
            predicateRef.set((stack, ref, entity) -> {
                SlotReference reference = SlotReference.of((LivingEntity)entity, (String)ref.inventory().getSlotType().getName(), (int)ref.index());
                AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(reference);
                Accessory accessory = AccessoriesAPI.getOrDefaultAccessory((ItemStack)stack);
                if (accessory != null) {
                    accessory.getDynamicModifiers(stack, reference, builder);
                }
                if (!builder.getAttributeModifiers(false).isEmpty()) {
                    return TriState.TRUE;
                }
                return TriState.DEFAULT;
            });
        }
        AccessoriesAPI.registerPredicate((ResourceLocation)id, (SlotBasedPredicate)new SafeSlotBasedPredicate(id, (Function3<ItemStack, dev.emi.trinkets.api.SlotReference, LivingEntity, TriState>)((Function3)predicateRef.get())));
    }

    @Overwrite(remap=false)
    public static boolean evaluatePredicateSet(Set<ResourceLocation> set, ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        HashSet<ResourceLocation> convertedSet = new HashSet<ResourceLocation>();
        for (ResourceLocation location : set) {
            ResourceLocation converetdLocation = switch (location.toString()) {
                case "trinkets:all" -> Accessories.of((String)"all");
                case "trinkets:none" -> Accessories.of((String)"none");
                case "trinkets:tag" -> Accessories.of((String)"tag");
                case "trinkets:relevant" -> Accessories.of((String)"relevant");
                default -> location;
            };
            convertedSet.add(converetdLocation);
        }
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotType slotType = SlotTypeLoader.getSlotType((Level)entity.level(), (String)slotName);
        if (slotType == null) {
            throw new IllegalStateException("Unable to get a SlotType using the WrappedTrinketInventory from the SlotTypeLoader! [Name: " + slotName + "]");
        }
        return AccessoriesAPI.getPredicateResults(convertedSet, (Level)entity.level(), (LivingEntity)entity, (SlotType)slotType, (int)ref.index(), (ItemStack)stack);
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")}, remap=false)
    private static void adjustDefaultTrinket(CallbackInfo ci) {
        DEFAULT_TRINKET = new TrinketFromAccessory(AccessoriesAPI.defaultAccessory());
    }
}

