/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.wrapper;

import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.Trinket;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketsWrappingUtils;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public record AccessoryFromTrinket(Trinket trinket) implements Accessory
{
    public void tick(ItemStack stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.tick(stack, reference);
            return;
        }
        this.trinket.tick(stack, ref.get(), reference.entity());
    }

    public void onEquip(ItemStack stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onEquip(stack, reference);
            return;
        }
        this.trinket.onEquip(stack, ref.get(), reference.entity());
    }

    public void onUnequip(ItemStack stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onUnequip(stack, reference);
            return;
        }
        this.trinket.onUnequip(stack, ref.get(), reference.entity());
    }

    public boolean canEquip(ItemStack stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.canEquip(stack, reference);
        }
        return this.trinket.canEquip(stack, ref.get(), reference.entity());
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.canUnequip(stack, reference);
        }
        return this.trinket.canUnequip(stack, ref.get(), reference.entity());
    }

    public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.getDynamicModifiers(stack, reference, builder);
        } else {
            ResourceLocation id = SlotAttributes.getIdentifier((dev.emi.trinkets.api.SlotReference)ref.get());
            this.trinket.getModifiers(stack, ref.get(), reference.entity(), id).asMap().forEach((attribute, modifiers) -> {
                for (AttributeModifier modifier : modifiers) {
                    if (modifier.id().equals((Object)id)) {
                        builder.addStackable(attribute, Accessories.of((String)"trinket_converted_attribute"), modifier.amount(), modifier.operation());
                        continue;
                    }
                    builder.addExclusive(attribute, modifier);
                }
            });
        }
    }

    public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.getDropRule(stack, reference, source);
        }
        return TrinketsWrappingUtils.convertDropRule(this.trinket.getDropRule(stack, ref.get(), reference.entity()));
    }

    public void onBreak(ItemStack stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            super.onBreak(stack, reference);
        } else {
            this.trinket.onBreak(stack, ref.get(), reference.entity());
        }
    }

    public boolean canEquipFromUse(ItemStack stack) {
        try {
            return this.trinket.canEquipFromUse(stack, null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        Optional<dev.emi.trinkets.api.SlotReference> ref = TrinketsWrappingUtils.createTrinketsReference(reference);
        if (ref.isEmpty()) {
            return super.getEquipSound(stack, reference);
        }
        Holder holder = this.trinket.getEquipSound(stack, ref.get(), reference.entity());
        if (holder == null) {
            return null;
        }
        return new SoundEventData(holder, 1.0f, 1.0f);
    }
}

