/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.utils;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories_compat.utils.ImmutableWrappingCollection;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ImmutableDelegatingMap<K, V, I>
implements Map<K, V> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final String debugNaming;
    private Runnable errorMessage;
    public final Class<K> keyClass;
    public final Class<V> valueClass;
    public final Map<K, I> map;
    public final UnaryOperator<K> toKeyNamespace;
    public final UnaryOperator<K> fromKeyNamespace;
    public final BiFunction<K, I, V> toValueMapFunc;
    public final Function<V, @Nullable I> fromValueMapFunc;

    public ImmutableDelegatingMap(String debugNaming, Class<K> keyClass, Class<V> valueClass, Map<K, I> map, UnaryOperator<K> toKeyNamespace, UnaryOperator<K> fromKeyNamespace, Function<I, V> toValueMapFunc, Function<V, @Nullable I> fromValueMapFunc) {
        this(debugNaming, keyClass, valueClass, map, toKeyNamespace, fromKeyNamespace, (K k, I i) -> toValueMapFunc.apply(i), fromValueMapFunc);
    }

    public ImmutableDelegatingMap(String debugNaming, Class<K> keyClass, Class<V> valueClass, Map<K, I> map, UnaryOperator<K> toKeyNamespace, UnaryOperator<K> fromKeyNamespace, BiFunction<K, I, V> toValueMapFunc, Function<V, @Nullable I> fromValueMapFunc) {
        this.debugNaming = debugNaming;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.map = map;
        this.toKeyNamespace = toKeyNamespace;
        this.fromKeyNamespace = fromKeyNamespace;
        this.toValueMapFunc = toValueMapFunc;
        this.fromValueMapFunc = fromValueMapFunc;
    }

    public ImmutableDelegatingMap<K, V, I> errorMessageSupplier(Runnable errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.keyClass.isInstance(key)) {
            return false;
        }
        return this.map.containsKey(this.fromKeyNamespace.apply(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.valueClass.isInstance(value)) {
            return false;
        }
        I possibleValue = this.fromValueMapFunc.apply(value);
        return possibleValue != null && this.map.containsValue(possibleValue);
    }

    @Override
    @Nullable
    public V get(Object key) {
        if (!this.keyClass.isInstance(key)) {
            return null;
        }
        Object convertedKey = this.fromKeyNamespace.apply(key);
        I entry = this.map.get(convertedKey);
        if (entry == null) {
            return null;
        }
        return this.toValueMapFunc.apply(key, entry);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new ImmutableWrappingCollection<K, Object>(this.map.keySet(), this.toKeyNamespace, (ks, object) -> ks.contains(this.fromKeyNamespace.apply(object)));
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new ImmutableWrappingCollection<Map.Entry, Object>(this.map.entrySet(), kiEntry -> this.toValueMapFunc.apply(kiEntry.getKey(), kiEntry.getValue()), (entries, v) -> this.map.containsValue(this.fromValueMapFunc.apply(v)));
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new ImmutableWrappingCollection<Map.Entry, Map.Entry>(this.map.entrySet(), kiEntry -> Map.entry(this.toKeyNamespace.apply(kiEntry.getKey()), this.toValueMapFunc.apply(kiEntry.getKey(), kiEntry.getValue())), (entries, kvEntry) -> {
            I entry = this.map.get(this.fromKeyNamespace.apply(kvEntry.getKey()));
            return Objects.equals(this.fromValueMapFunc.apply(kvEntry.getValue()), entry);
        });
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        return null;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
    }
}

