/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.utils;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ImmutableWrappingCollection<V, T>
extends AbstractCollection<T>
implements Set<T> {
    final Set<V> collection;
    final Function<V, T> toCollectionType;
    final BiPredicate<Collection<V>, T> containsCheck;

    public ImmutableWrappingCollection(Set<V> collection, Function<V, T> toCollectionType, BiPredicate<Collection<V>, T> containsCheck) {
        this.collection = collection;
        this.toCollectionType = toCollectionType;
        this.containsCheck = containsCheck;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        try {
            return this.containsCheck.test((Collection<V>)this.collection, (Set<V>)o);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.collection.isEmpty()) {
            return Collections.emptyIterator();
        }
        final Iterator<V> itr = this.collection.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public T next() {
                return ImmutableWrappingCollection.this.toCollectionType.apply(itr.next());
            }
        };
    }

    @Override
    public int size() {
        return this.collection.size();
    }
}

