/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.commands.args.TagArgument;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;

public class BlockTagToItemTagCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext context) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)"block_to_item_tag").requires((Predicate)PermissionLevel.GAMEMASTER);
        root.then(Commands.argument((String)"block_tag", TagArgument.arg(context, Registries.BLOCK)).executes(ctx -> {
            TagKey result = TagArgument.get("block_tag", (CommandContext<CommandSourceStack>)ctx, Registries.BLOCK);
            HolderSet.Named tag = (HolderSet.Named)BuiltInRegistries.BLOCK.getTag(result).orElseThrow();
            HashSet<BlockItem> items = new HashSet<BlockItem>();
            for (Item item : BuiltInRegistries.ITEM) {
                BlockItem blockItem;
                if (!(item instanceof BlockItem) || !tag.contains((Holder)(blockItem = (BlockItem)item).getBlock().builtInRegistryHolder())) continue;
                items.add(blockItem);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> TextHelper.copyText(Constants.GSON_PRETTY.toJson((JsonElement)BlockTagToItemTagCommand.tagJson(items, arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)))), false);
            return 0;
        }));
        return root;
    }

    private static <T> JsonObject tagJson(Collection<T> entries, Function<T, ResourceLocation> idFunc) {
        JsonArray array = new JsonArray();
        entries.stream().map(entry -> ((ResourceLocation)idFunc.apply(entry)).toString()).sorted().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        JsonObject obj = new JsonObject();
        obj.add("values", (JsonElement)array);
        return obj;
    }
}

