/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.data.ingredient;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.ingredient.IngredientLogic;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BlockTagIngredient
implements IngredientLogic<BlockTagIngredient> {
    public static final MapCodec<BlockTagIngredient> CODEC = MapCodecs.flexibleList(TagKey.codec((ResourceKey)Registries.BLOCK)).xmap(BlockTagIngredient::new, l -> l.blockTags).fieldOf("tag");
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockTagIngredient> STREAM = StreamCodec.of((buf, val) -> buf.writeCollection(val.blockTags, (b1, tag) -> b1.writeResourceLocation(tag.location())), buf -> new BlockTagIngredient((List)buf.readCollection(ArrayList::new, b1 -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)b1.readResourceLocation()))));
    private final List<TagKey<Block>> blockTags;
    private List<ItemStack> matches;

    public BlockTagIngredient(List<TagKey<Block>> blockTags) {
        this.blockTags = blockTags;
    }

    @Override
    public List<ItemStack> getAllMatchingStacks() {
        if (this.matches == null) {
            this.matches = new ArrayList<ItemStack>();
            for (TagKey<Block> tag : this.blockTags) {
                for (Holder entry : BuiltInRegistries.BLOCK.getTagOrEmpty(tag)) {
                    ItemStack stack = new ItemStack((ItemLike)entry.value());
                    if (stack.isEmpty()) continue;
                    this.matches.add(stack);
                }
            }
        }
        return this.matches;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        for (ItemStack valid : this.getAllMatchingStacks()) {
            if (valid.getItem() != stack.getItem()) continue;
            return true;
        }
        return false;
    }
}

