/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.block;

import com.jkvin114.displaydelight.block.AbstractItemBlock;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayBlocks;
import com.jkvin114.displaydelight.init.DisplayProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractStackablePlatedFoodBlock
extends AbstractItemBlock {
    public static final IntegerProperty STACKS = DisplayProperties.STACKS;

    public AbstractStackablePlatedFoodBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)STACKS, (Comparable)Integer.valueOf(6)));
    }

    public BlockState getStateFrom(BlockState plate, Direction direction, int count) {
        if (plate.is((Block)DisplayBlocks.PLATE.get())) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue((Property)STACKS, (Comparable)Integer.valueOf(Math.min(count, this.getMaxStackable())));
        }
        return this.defaultBlockState();
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return this.getStackFor();
    }

    @Override
    public ItemStack getStackFor() {
        return new ItemStack((ItemLike)BlockAssociations.getPlatedItemFor((Block)this));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STACKS});
    }

    public int getStacks(BlockState state) {
        return (Integer)state.getValue((Property)STACKS);
    }

    public BlockState getDecrementedState(BlockState state) {
        return (BlockState)state.setValue((Property)STACKS, (Comparable)Integer.valueOf(Math.max(this.getStacks(state) - 1, 1)));
    }

    public BlockState getIncrementedState(BlockState state, int count) {
        return (BlockState)state.setValue((Property)STACKS, (Comparable)Integer.valueOf(Math.min(this.getStacks(state) + count, this.getMaxStackable())));
    }

    public abstract int getMaxStackable();

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return AbstractStackablePlatedFoodBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    }
}

