/*
 * Decompiled with CFR 0.152.
 */
package com.kubepixel.cinematiczoom.client;

import com.kubepixel.cinematiczoom.config.Config;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;

public class ClientHandler {
    private static final KeyMapping ZOOM_KEY = new KeyMapping("key.cinematiczoom.zoom", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 67, "key.categories.cinematiczoom");
    private boolean isZooming = false;
    private long animationStartTime = 0L;
    private float targetZoomFactor = 1.0f;
    private float currentZoomFactor = 1.0f;
    private boolean soundPlayed = false;
    private boolean originalHideGuiState = false;

    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ZOOM_KEY);
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (ZOOM_KEY.isDown() && !this.isZooming) {
            this.isZooming = true;
            this.animationStartTime = System.currentTimeMillis();
            this.soundPlayed = false;
            this.originalHideGuiState = mc.options.hideGui;
            mc.options.hideGui = true;
            boolean isThirdPerson = !mc.options.getCameraType().isFirstPerson();
            this.currentZoomFactor = this.targetZoomFactor = (isThirdPerson ? (Double)Config.CLIENT.thirdPersonDefaultZoom.get() : (Double)Config.CLIENT.firstPersonDefaultZoom.get()).floatValue();
            if (((Boolean)Config.CLIENT.enableZoomSounds.get()).booleanValue() && !this.soundPlayed) {
                mc.player.level().playSound((Player)mc.player, mc.player.blockPosition(), SoundEvents.SPYGLASS_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.soundPlayed = true;
            }
        } else if (!ZOOM_KEY.isDown() && this.isZooming) {
            this.isZooming = false;
            this.animationStartTime = System.currentTimeMillis();
            this.soundPlayed = false;
            mc.options.hideGui = this.originalHideGuiState;
            if (((Boolean)Config.CLIENT.enableZoomSounds.get()).booleanValue() && !this.soundPlayed) {
                mc.player.level().playSound((Player)mc.player, mc.player.blockPosition(), SoundEvents.SPYGLASS_STOP_USING, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.soundPlayed = true;
            }
        }
        if (this.isZooming) {
            float smoothSpeed = ((Double)Config.CLIENT.smoothZoomSpeed.get()).floatValue();
            this.currentZoomFactor = Mth.lerp((float)smoothSpeed, (float)this.currentZoomFactor, (float)this.targetZoomFactor);
        }
    }

    @SubscribeEvent
    public void onComputeFov(ViewportEvent.ComputeFov event) {
        float animationProgress = this.getAnimationProgress();
        if (animationProgress <= 0.0f) {
            this.currentZoomFactor = 1.0f;
            return;
        }
        float baseFov = (float)event.getFOV();
        float targetFov = baseFov * this.currentZoomFactor;
        float finalFov = Mth.lerp((float)this.getEasedProgress(animationProgress), (float)baseFov, (float)targetFov);
        event.setFOV((double)finalFov);
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (this.isZooming && event.getScrollDeltaY() != 0.0) {
            float step = ((Double)Config.CLIENT.zoomStep.get()).floatValue();
            float minZoom = ((Double)Config.CLIENT.minZoomFactor.get()).floatValue();
            float maxZoom = ((Double)Config.CLIENT.maxZoomFactor.get()).floatValue();
            this.targetZoomFactor -= (float)event.getScrollDeltaY() * step;
            this.targetZoomFactor = Mth.clamp((float)this.targetZoomFactor, (float)minZoom, (float)maxZoom);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (this.isZooming) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiEvent.Post event) {
        float animationProgress = this.getAnimationProgress();
        if (animationProgress <= 0.0f) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int barHeight = screenHeight / 8;
        int alpha = (int)(this.getEasedProgress(animationProgress) * 255.0f);
        int color = alpha << 24;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        guiGraphics.fill(0, 0, screenWidth, barHeight, color);
        guiGraphics.fill(0, screenHeight - barHeight, screenWidth, screenHeight, color);
        RenderSystem.disableBlend();
    }

    private float getAnimationProgress() {
        long duration = ((Integer)Config.CLIENT.animationDurationMs.get()).intValue();
        if (duration <= 0L) {
            return this.isZooming ? 1.0f : 0.0f;
        }
        long timeElapsed = System.currentTimeMillis() - this.animationStartTime;
        float progress = Mth.clamp((float)((float)timeElapsed / (float)duration), (float)0.0f, (float)1.0f);
        return this.isZooming ? progress : 1.0f - progress;
    }

    private float getEasedProgress(float progress) {
        return progress < 0.5f ? 4.0f * progress * progress * progress : 1.0f - (float)Math.pow(-2.0f * progress + 2.0f, 3.0) / 2.0f;
    }
}

