/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.requirements;

import fox.mods.access_denied.config.AccessDeniedConfiguration;
import fox.mods.access_denied.network.AccessDeniedModVariables;
import fox.mods.access_denied.requirements.DimensionRequirement;
import fox.mods.access_denied.requirements.DimensionRequirementsLoader;
import fox.mods.access_denied.util.FtbQuestsHelper;
import fox.mods.access_denied.util.RegistriesUtils;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class DimensionRequirementChecker {
    public static boolean passedRequirements(Player player, String dimensionKey) {
        boolean requirementsPassed = false;
        DimensionRequirement requirement = DimensionRequirementsLoader.getRequirements().get(dimensionKey);
        if (DimensionRequirementChecker.passedBlocksBrokenRequirement(player, requirement) && DimensionRequirementChecker.passedBlocksPlacedRequirement(player, requirement) && DimensionRequirementChecker.passedXpRequirement(player, requirement) && DimensionRequirementChecker.passedPlayerKillsRequirement(player, requirement) && DimensionRequirementChecker.passedMobKillsRequirement(player, requirement) && DimensionRequirementChecker.passedPlayTimeRequirement(player, requirement) && DimensionRequirementChecker.passedItemsKeyRequirement(player, requirement) && DimensionRequirementChecker.passedEffectsRequirement(player, requirement) && DimensionRequirementChecker.passedHealthRequirement(player, requirement) && DimensionRequirementChecker.passedDeathsRequirement(player, requirement) && DimensionRequirementChecker.passedChanceRequirement(player, requirement) && DimensionRequirementChecker.passedAdvancementsRequirement(player, requirement) && DimensionRequirementChecker.passedJumpsRequirement(player, requirement) && DimensionRequirementChecker.passedTimesFishedRequirement(player, requirement)) {
            if (DimensionRequirementsLoader.ftbQuests.booleanValue()) {
                if (DimensionRequirementChecker.passedFtbQuestsRequirement(player, requirement)) {
                    requirementsPassed = true;
                }
                return requirementsPassed;
            }
            requirementsPassed = true;
        }
        return requirementsPassed;
    }

    private static boolean passedBlocksBrokenRequirement(Player player, DimensionRequirement requirement) {
        int blocksBroken;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((blocksBroken = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksBroken) >= requirement.blocksBroken()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedBlocksPlacedRequirement(Player player, DimensionRequirement requirement) {
        int blocksPlaced;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((blocksPlaced = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksPlaced) >= requirement.blocksPlaced()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedXpRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if (player.experienceLevel >= requirement.xpLevel()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedPlayerKillsRequirement(Player player, DimensionRequirement requirement) {
        int playerKills;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((playerKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playerKills) >= requirement.playerKills()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedMobKillsRequirement(Player player, DimensionRequirement requirement) {
        int mobKills;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((mobKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).mobKills) >= requirement.mobKills()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedPlayTimeRequirement(Player player, DimensionRequirement requirement) {
        int playTime;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((playTime = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playTime) >= requirement.playTime()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedItemsKeyRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        int passedItems = 0;
        if (requirement.itemsKey() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        for (int i = 0; i < requirement.itemsKey().size(); ++i) {
            Item itemKey = RegistriesUtils.itemFromRegistryName(requirement.itemsKey().get(i));
            if (!player.getInventory().contains(new ItemStack((ItemLike)itemKey)) && itemKey != Items.AIR) continue;
            ++passedItems;
        }
        if (passedItems == requirement.itemsKey().size()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedEffectsRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if (requirement.effects() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int effectsPassed = 0;
        for (int i = 0; i < requirement.effects().size(); ++i) {
            Holder.Reference<MobEffect> effect = RegistriesUtils.effectFromRegistryName(requirement.effects().get(i));
            if (!player.hasEffect(effect) && effect != MobEffects.HEAL) continue;
            ++effectsPassed;
        }
        if (effectsPassed == requirement.effects().size()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedHealthRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if (player.getHealth() >= requirement.health()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedDeathsRequirement(Player player, DimensionRequirement requirement) {
        int deaths;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((deaths = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).deaths) >= requirement.deaths()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedChanceRequirement(Player player, DimensionRequirement requirement) {
        double requirementChance;
        double chance;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((chance = Math.random()) <= (requirementChance = (double)requirement.chance() / 100.0) || requirement.chance() == 0) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedAdvancementsRequirement(Player player, DimensionRequirement requirement) {
        ServerPlayer serverPlayer;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if (requirement.advancements() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int passedAdvancements = 0;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).level() instanceof ServerLevel) {
            for (int i = 0; i < requirement.advancements().size(); ++i) {
                if (!RegistriesUtils.getAdvancementDisplayName(serverPlayer.getServer(), requirement.advancements().get(i)).equals("") && !serverPlayer.getAdvancements().getOrStartProgress(serverPlayer.server.getAdvancements().get(ResourceLocation.parse((String)requirement.advancements().get(i)))).isDone()) continue;
                ++passedAdvancements;
            }
        }
        if (passedAdvancements == requirement.advancements().size()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedFtbQuestsRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null || !DimensionRequirementsLoader.ftbQuests.booleanValue()) {
            requirementPassed = true;
            return requirementPassed;
        }
        int passedQuests = 0;
        if (requirement.ftbQuestIds() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (int i = 0; i < requirement.ftbQuestIds().size(); ++i) {
                if (!FtbQuestsHelper.isQuestCompleted(serverPlayer, requirement.ftbQuestIds().get(i))) continue;
                ++passedQuests;
            }
        }
        if (passedQuests == requirement.ftbQuestIds().size()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedJumpsRequirement(Player player, DimensionRequirement requirement) {
        int jumps;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((jumps = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).jumps) >= requirement.jumps()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedTimesFishedRequirement(Player player, DimensionRequirement requirement) {
        int timesFished;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
        }
        if ((timesFished = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).timesFished) >= requirement.timesFished()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    public static void ShowRequirementsMessage(Player player, DimensionRequirement requirement) {
        ServerPlayer serverPlayer;
        String sectionToAppend;
        if (requirement == null) {
            return;
        }
        int blocksBroken = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksBroken;
        int blocksPlaced = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksPlaced;
        int playerKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playerKills;
        int mobKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).mobKills;
        int playTime = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playTime;
        int deaths = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).deaths;
        int jumps = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).jumps;
        int timesFished = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).timesFished;
        boolean showBlocksBrokenRequirement = !DimensionRequirementChecker.passedBlocksBrokenRequirement(player, requirement);
        boolean showBlocksPlacedRequirement = !DimensionRequirementChecker.passedBlocksPlacedRequirement(player, requirement);
        boolean showXpRequirement = !DimensionRequirementChecker.passedXpRequirement(player, requirement);
        boolean showPlayerKillsRequirement = !DimensionRequirementChecker.passedPlayerKillsRequirement(player, requirement);
        boolean showMobKillsRequirement = !DimensionRequirementChecker.passedMobKillsRequirement(player, requirement);
        boolean showPlayTimeRequirement = !DimensionRequirementChecker.passedPlayTimeRequirement(player, requirement);
        boolean showItemKeyRequirement = !DimensionRequirementChecker.passedItemsKeyRequirement(player, requirement);
        boolean showEffectRequirement = !DimensionRequirementChecker.passedEffectsRequirement(player, requirement);
        boolean showHealthRequirement = !DimensionRequirementChecker.passedHealthRequirement(player, requirement);
        boolean showDeathsRequirement = !DimensionRequirementChecker.passedDeathsRequirement(player, requirement);
        boolean showChanceRequirement = !DimensionRequirementChecker.passedChanceRequirement(player, requirement);
        boolean showAdvancementRequirement = !DimensionRequirementChecker.passedAdvancementsRequirement(player, requirement);
        boolean showFtbQuestsRequirement = !DimensionRequirementChecker.passedFtbQuestsRequirement(player, requirement) && DimensionRequirementsLoader.ftbQuests != false;
        boolean showJumpsRequirement = !DimensionRequirementChecker.passedJumpsRequirement(player, requirement);
        boolean showTimesFishedRequirement = !DimensionRequirementChecker.passedTimesFishedRequirement(player, requirement);
        StringBuilder message = new StringBuilder(ChatFormatting.RED.toString() + AccessDeniedConfiguration.requirementsMessageBuilder.get(0) + "\n");
        if (showBlocksBrokenRequirement) {
            int missingBlocksToBreak = requirement.blocksBroken() - blocksBroken;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(1).replace("%missingBlocksBroken%", ChatFormatting.YELLOW.toString() + missingBlocksToBreak + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showBlocksPlacedRequirement) {
            int missingBlocksToPlace = requirement.blocksPlaced() - blocksPlaced;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(2).replace("%missingBlocksPlaced%", ChatFormatting.YELLOW.toString() + missingBlocksToPlace + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showXpRequirement) {
            int missingXp = requirement.xpLevel() - player.experienceLevel;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(3).replace("%missingXpLevels%", ChatFormatting.YELLOW.toString() + missingXp + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showPlayerKillsRequirement) {
            int missingPlayerKills = requirement.playerKills() - playerKills;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(4).replace("%missingPlayerKills%", ChatFormatting.YELLOW.toString() + missingPlayerKills + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showMobKillsRequirement) {
            int missingMobKills = requirement.mobKills() - mobKills;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(5).replace("%missingMobKills%", ChatFormatting.YELLOW.toString() + missingMobKills + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showPlayTimeRequirement) {
            int missingPlayTime = requirement.playTime() - playTime;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(6).replace("%missingPlayTime%", ChatFormatting.YELLOW.toString() + missingPlayTime + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showItemKeyRequirement) {
            StringBuilder itemsKeyMessage = new StringBuilder();
            for (int i = 0; i < requirement.itemsKey().size(); ++i) {
                String missingItem = RegistriesUtils.itemFromRegistryName(requirement.itemsKey().get(i)).getName(new ItemStack((ItemLike)RegistriesUtils.itemFromRegistryName(requirement.itemsKey().get(i)))).getString();
                if (player.getInventory().contains(new ItemStack((ItemLike)RegistriesUtils.itemFromRegistryName(requirement.itemsKey().get(i)))) || RegistriesUtils.itemFromRegistryName(requirement.itemsKey().get(i)) == Items.AIR) continue;
                if (i == requirement.itemsKey().size() - 1) {
                    itemsKeyMessage.append(ChatFormatting.YELLOW.toString() + missingItem);
                    continue;
                }
                itemsKeyMessage.append(ChatFormatting.YELLOW.toString() + missingItem + ", ");
            }
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(7).replace("%missingItems%", ChatFormatting.YELLOW.toString() + String.valueOf(itemsKeyMessage) + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showEffectRequirement) {
            StringBuilder effectsMessage = new StringBuilder();
            for (int i = 0; i < requirement.effects().size(); ++i) {
                String missingEffect = RegistriesUtils.getEffectDisplayName(RegistriesUtils.effectFromRegistryName(requirement.effects().get(i)));
                if (player.hasEffect(RegistriesUtils.effectFromRegistryName(requirement.effects().get(i))) || RegistriesUtils.effectFromRegistryName(requirement.effects().get(i)) == MobEffects.HEAL) continue;
                if (i == requirement.effects().size() - 1) {
                    effectsMessage.append(ChatFormatting.YELLOW.toString() + missingEffect);
                    continue;
                }
                effectsMessage.append(ChatFormatting.YELLOW.toString() + missingEffect + ", ");
            }
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(8).replace("%missingEffects%", ChatFormatting.YELLOW.toString() + String.valueOf(effectsMessage) + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showHealthRequirement) {
            float missingHealth = (requirement.health() - player.getHealth()) / 2.0f;
            String formattedMissingHealth = new DecimalFormat("##.#").format(missingHealth);
            String sectionToAppend2 = AccessDeniedConfiguration.requirementsMessageBuilder.get(9).replace("%missingHealth%", ChatFormatting.YELLOW.toString() + formattedMissingHealth + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend2);
        }
        if (showDeathsRequirement) {
            int missingDeaths = requirement.deaths() - deaths;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(10).replace("%missingDeaths%", ChatFormatting.YELLOW.toString() + missingDeaths + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showChanceRequirement) {
            String sectionToAppend3 = AccessDeniedConfiguration.requirementsMessageBuilder.get(11).replace("%chance%", ChatFormatting.YELLOW.toString() + requirement.chance() + "%" + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend3);
        }
        if (showAdvancementRequirement) {
            StringBuilder advancementsMessage = new StringBuilder();
            if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).level() instanceof ServerLevel) {
                for (int i = 0; i < requirement.advancements().size(); ++i) {
                    String missingAdvancement = "";
                    missingAdvancement = RegistriesUtils.getAdvancementDisplayName(serverPlayer.getServer(), requirement.advancements().get(i));
                    if (RegistriesUtils.getAdvancementDisplayName(serverPlayer.getServer(), requirement.advancements().get(i)).equals("") || serverPlayer.getAdvancements().getOrStartProgress(serverPlayer.server.getAdvancements().get(ResourceLocation.parse((String)requirement.advancements().get(i)))).isDone()) continue;
                    if (i == requirement.advancements().size() - 1) {
                        advancementsMessage.append(ChatFormatting.YELLOW.toString() + missingAdvancement);
                        continue;
                    }
                    advancementsMessage.append(ChatFormatting.YELLOW.toString() + missingAdvancement + ", ");
                }
            }
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(12).replace("%missingAdvancements%", ChatFormatting.YELLOW.toString() + String.valueOf(advancementsMessage) + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showFtbQuestsRequirement) {
            StringBuilder ftbQuestsMessage = new StringBuilder();
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                for (int i = 0; i < requirement.ftbQuestIds().size(); ++i) {
                    String missingQuest = "";
                    missingQuest = FtbQuestsHelper.getQuestTitle(requirement.ftbQuestIds().get(i)).getString();
                    if (FtbQuestsHelper.isQuestCompleted(serverPlayer, requirement.ftbQuestIds().get(i))) continue;
                    if (i == requirement.ftbQuestIds().size() - 1) {
                        ftbQuestsMessage.append(ChatFormatting.YELLOW.toString() + missingQuest);
                        continue;
                    }
                    ftbQuestsMessage.append(ChatFormatting.YELLOW.toString() + missingQuest + ", ");
                }
            }
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(13).replace("%missingFtbQuests%", ChatFormatting.YELLOW.toString() + String.valueOf(ftbQuestsMessage) + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showJumpsRequirement) {
            int missingJumps = requirement.jumps() - jumps;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(14).replace("%missingJumps%", ChatFormatting.YELLOW.toString() + missingJumps + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        if (showTimesFishedRequirement) {
            int missingFishingCount = requirement.timesFished() - timesFished;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(15).replace("%missingFishingCount%", ChatFormatting.YELLOW.toString() + missingFishingCount + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend);
        }
        message.append(AccessDeniedConfiguration.requirementsMessageBuilder.get(16));
        player.displayClientMessage((Component)Component.literal((String)message.toString()), false);
    }

    public static void showAccessDeniedMessage(Player player) {
        player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + ChatFormatting.BOLD.toString() + AccessDeniedConfiguration.accessDeniedMessage)), true);
    }
}

