/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelCustomModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"butcher", (String)"model_custom_model"), "main");
    public final ModelPart Head;
    public final ModelPart Body;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelCustomModel(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.7f, -9.0f, -4.4f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightHeadSpike_r1 = Head.addOrReplaceChild("RightHeadSpike_r1", CubeListBuilder.create().texOffs(43, 52).mirror().addBox(-3.5f, -3.5f, 0.0f, 7.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.2f, (float)-8.5f, (float)0.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        PartDefinition LeftHeadSpike_r1 = Head.addOrReplaceChild("LeftHeadSpike_r1", CubeListBuilder.create().texOffs(43, 52).addBox(-3.5f, -3.5f, 0.0f, 7.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.8f, (float)-8.5f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, 0.0f, -2.475f, 8.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(21, 34).addBox(-3.5f, -2.3f, -2.5f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightArmLower_r1 = RightArm.addOrReplaceChild("RightArmLower_r1", CubeListBuilder.create().texOffs(48, 40).mirror().addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.8f, (float)-1.8f, (float)0.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        PartDefinition RightArmLower_r2 = RightArm.addOrReplaceChild("RightArmLower_r2", CubeListBuilder.create().texOffs(48, 40).mirror().addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)11.0f, (float)2.2f, (float)3.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition RightArmLower_r3 = RightArm.addOrReplaceChild("RightArmLower_r3", CubeListBuilder.create().texOffs(48, 40).mirror().addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)2.2f, (float)3.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition RightArmLower_r4 = RightArm.addOrReplaceChild("RightArmLower_r4", CubeListBuilder.create().texOffs(48, 40).mirror().addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.8f, (float)4.2f, (float)0.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(26, 18).addBox(-1.7f, -2.3f, -2.5f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftArmLower_r1 = LeftArm.addOrReplaceChild("LeftArmLower_r1", CubeListBuilder.create().texOffs(48, 40).addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8f, (float)4.2f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition LeftArmLower_r2 = LeftArm.addOrReplaceChild("LeftArmLower_r2", CubeListBuilder.create().texOffs(48, 40).addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8f, (float)-1.8f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 39).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(36, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

