/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesHolder {
    @Nullable
    public static AccessoriesHolder get(@NotNull LivingEntity livingEntity) {
        return livingEntity.accessoriesHolder();
    }

    public static Optional<AccessoriesHolder> getOptionally(@NotNull LivingEntity livingEntity) {
        return Optional.ofNullable(AccessoriesHolder.get(livingEntity));
    }

    public AccessoriesHolderLookupCache getLookupCache();

    public PlayerEquipControl equipControl();

    public AccessoriesHolder equipControl(PlayerEquipControl var1);

    public boolean showUnusedSlots();

    public AccessoriesHolder showUnusedSlots(boolean var1);

    public boolean cosmeticsShown();

    public AccessoriesHolder cosmeticsShown(boolean var1);

    public boolean showAdvancedOptions();

    public AccessoriesHolder showAdvancedOptions(boolean var1);

    public int columnAmount();

    public AccessoriesHolder columnAmount(int var1);

    public int widgetType();

    public AccessoriesHolder widgetType(int var1);

    public boolean showGroupFilter();

    public AccessoriesHolder showGroupFilter(boolean var1);

    public boolean isGroupFiltersOpen();

    public AccessoriesHolder isGroupFiltersOpen(boolean var1);

    public Set<String> filteredGroups();

    public AccessoriesHolder filteredGroups(Set<String> var1);

    public boolean mainWidgetPosition();

    public AccessoriesHolder mainWidgetPosition(boolean var1);

    public boolean sideWidgetPosition();

    public AccessoriesHolder sideWidgetPosition(boolean var1);

    public boolean showCraftingGrid();

    public AccessoriesHolder showCraftingGrid(boolean var1);

    @Deprecated(forRemoval=true)
    default public boolean showUniqueSlots() {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public AccessoriesHolder showUniqueSlots(boolean value) {
        return this;
    }

    @Deprecated(forRemoval=true)
    default public boolean linesShown() {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public AccessoriesHolder linesShown(boolean value) {
        return this;
    }
}

