/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.google.common.base.CaseFormat;
import com.google.common.base.Supplier;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.rendering.CustomDataRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunctionPredicate;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Experimental
public sealed interface RenderingFunction
permits CustomDataRenderer, Block, Compound, Conditional, Entity, Item, Model, Particle, Transformation {
    public static final Endec<RenderingFunction> ENDEC = Endec.dispatchedStruct(key -> switch (key) {
        case "transformation" -> Transformation.ENDEC;
        case "model" -> Model.ENDEC;
        case "block" -> Block.ENDEC;
        case "item" -> Item.ENDEC;
        case "entity" -> Entity.ENDEC;
        case "particle" -> Particle.ENDEC;
        case "compound" -> Compound.ENDEC;
        case "renderer" -> CustomDataRenderer.ENDEC;
        case "conditional" -> Conditional.ENDEC;
        default -> throw new IllegalStateException("A invalid rendering function was created meaning such is unable to be decoded!");
    }, RenderingFunction::key, (Endec)Endec.STRING, (String)"type");

    public static Transformation ofTransformation(List<io.wispforest.accessories.api.client.Transformation> transformations, RenderingFunction innerRendering) {
        return new Transformation(transformations, innerRendering);
    }

    public static Model ofModel(ResourceLocation id, String variant) {
        return new Model(id, variant);
    }

    public static Block ofBlock(net.minecraft.world.level.block.Block block) {
        return RenderingFunction.ofBlock(block.defaultBlockState());
    }

    public static Block ofBlock(BlockState state) {
        return new Block(state, null, new CompoundTag());
    }

    public static Block ofBlockEntity(net.minecraft.world.level.block.Block block, BlockEntityType<? extends BlockEntity> type, Level level) {
        return RenderingFunction.ofBlockEntity(block.defaultBlockState(), type, level);
    }

    public static Block ofBlockEntity(BlockState blockState, BlockEntityType<? extends BlockEntity> type, Level level) {
        BlockEntity blockEntity = type.create(BlockPos.ZERO, blockState);
        if (blockEntity == null) {
            throw new IllegalStateException("Unable to create render function of the given block entity");
        }
        return RenderingFunction.ofBlockEntity(blockState, type, blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()));
    }

    public static Block ofBlockEntity(BlockState blockState, BlockEntityType<? extends BlockEntity> type, CompoundTag data) {
        return new Block(blockState, type, data);
    }

    public static Item ofItem(ItemStack stack) {
        return new Item(stack);
    }

    public static Entity ofEntity(EntityType<? extends net.minecraft.world.entity.Entity> entityType, Level level) {
        net.minecraft.world.entity.Entity entity = entityType.create(level);
        if (entity == null) {
            throw new IllegalStateException("Unable to create render function of the given entity");
        }
        CompoundTag compound = new CompoundTag();
        String string = entity.getEncodeId();
        if (string == null) {
            throw new IllegalStateException("Unable to create render function of the given entity");
        }
        compound.putString("id", string);
        entity.saveWithoutId(compound);
        return new Entity(entityType, compound, true);
    }

    public static Entity ofEntity(EntityType<? extends net.minecraft.world.entity.Entity> entityType, CompoundTag data) {
        return new Entity(entityType, data, true);
    }

    public static Particle ofParticle(ResourceLocation uniqueId, float delay, ParticleOptions particleData, Vector3f delta, float speed, int count, boolean force) {
        return new Particle(uniqueId, delay, particleData, delta, speed, count, force);
    }

    default public String key() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName());
    }

    public record Transformation(List<io.wispforest.accessories.api.client.Transformation> transformations, RenderingFunction renderingFunction) implements RenderingFunction
    {
        public static final StructEndec<Transformation> ENDEC = StructEndecBuilder.of((StructField)io.wispforest.accessories.api.client.Transformation.ENDEC.listOf().fieldOf("transformations", Transformation::transformations), (StructField)ENDEC.fieldOf("rendering_function", Transformation::renderingFunction), Transformation::new);
    }

    public record Model(ResourceLocation id, String variant) implements RenderingFunction
    {
        public static final StructEndec<Model> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("id", Model::id), (StructField)Endec.STRING.optionalFieldOf("variant", Model::variant, () -> ""), Model::new);
    }

    public record Block(BlockState state, @Nullable BlockEntityType<?> type, CompoundTag data) implements RenderingFunction
    {
        public static final StructEndec<Block> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.blockStateEndec("id").flatFieldOf(Block::state), (StructField)CodecUtils.toEndec((Codec)BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec()).optionalFieldOf("entity_id", Block::type, (Object)null), (StructField)NbtEndec.COMPOUND.optionalFieldOf("data", Block::data, CompoundTag::new), Block::new);
    }

    public record Item(ItemStack stack) implements RenderingFunction
    {
        public static final StructEndec<Item> ENDEC = StructEndecBuilder.of((StructField)new EndecUtils.LazyStructEndec(() -> {
            Codec baseCodec = ItemStack.CODEC;
            try {
                Field field = baseCodec.getClass().getDeclaredField("wrapped");
                field.setAccessible(true);
                Supplier supplier = (Supplier)field.get(baseCodec);
                return CodecUtils.toStructEndec((MapCodec)((MapCodec.MapCodecCodec)supplier.get()).codec());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }).flatFieldOf(Item::stack), Item::new);
    }

    public record Entity(EntityType<?> entityType, CompoundTag data, boolean allowTicking) implements RenderingFunction
    {
        public static final StructEndec<Entity> ENDEC = StructEndecBuilder.of((StructField)CodecUtils.toEndec((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec()).fieldOf("entity_id", Entity::entityType), (StructField)NbtEndec.COMPOUND.optionalFieldOf("stack", Entity::data, CompoundTag::new), (StructField)Endec.BOOLEAN.optionalFieldOf("allow_ticking", Entity::allowTicking, (Object)false), Entity::new);
    }

    public record Particle(ResourceLocation uniqueId, float delay, ParticleOptions particleData, Vector3f delta, float speed, int count, boolean force) implements RenderingFunction
    {
        private static final Endec<ParticleOptions> PARTICLE_OPTIONS_ENDEC = CodecUtils.toEndec((Codec)ParticleTypes.CODEC);
        public static final StructEndec<Particle> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.optionalFieldOf("unique_id", Particle::uniqueId, () -> Accessories.of("shared")), (StructField)Endec.FLOAT.optionalFieldOf("delay", Particle::delay, () -> Float.valueOf(20.0f)), (StructField)PARTICLE_OPTIONS_ENDEC.fieldOf("particle_data", Particle::particleData), (StructField)EndecUtils.VECTOR_3_F_ENDEC.flatFieldOf(Particle::delta), (StructField)Endec.FLOAT.optionalFieldOf("speed", Particle::speed, (Object)Float.valueOf(1.0f)), (StructField)Endec.INT.optionalFieldOf("count", Particle::count, (Object)1), (StructField)Endec.BOOLEAN.optionalFieldOf("force", Particle::force, (Object)false), Particle::new);

        @Override
        public boolean equals(Object obj) {
            EdmElement thatRawParticleData;
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Particle that = (Particle)obj;
            EdmElement rawParticleData = (EdmElement)PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)this.particleData);
            return Objects.equals(rawParticleData, thatRawParticleData = (EdmElement)PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)that.particleData)) && Objects.equals(this.delta, that.delta) && Float.floatToIntBits(this.speed) == Float.floatToIntBits(that.speed) && this.count == that.count && this.force == that.force;
        }

        @Override
        public int hashCode() {
            return Objects.hash(PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)this.particleData), this.delta, Float.valueOf(this.speed), this.count, this.force);
        }

        @Override
        public String toString() {
            return "Particle[particleData=" + String.valueOf(this.particleData) + ", delta=" + String.valueOf(this.delta) + ", speed=" + this.speed + ", count=" + this.count + ", force=" + this.force + "]";
        }
    }

    public record Compound(List<RenderingFunction> renderingFunctions, ArmTarget firstPersonArmTarget) implements RenderingFunction
    {
        public static final StructEndec<Compound> ENDEC = StructEndecBuilder.of((StructField)ENDEC.listOf().fieldOf("rendering_functions", Compound::renderingFunctions), (StructField)Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", Compound::firstPersonArmTarget, () -> ArmTarget.NONE), Compound::new);
    }

    public record Conditional(List<RenderingFunctionPredicate> predicates, RenderingFunction renderingFunction) implements RenderingFunction
    {
        public static final StructEndec<Conditional> ENDEC = StructEndecBuilder.of((StructField)RenderingFunctionPredicate.ENDEC.listOf().fieldOf("predicates", Conditional::predicates), (StructField)ENDEC.fieldOf("rendering_function", Conditional::renderingFunction), Conditional::new);
    }

    public static enum ArmTarget {
        LEFT(HumanoidArm.LEFT),
        RIGHT(HumanoidArm.RIGHT),
        BOTH(HumanoidArm.LEFT, HumanoidArm.RIGHT),
        NONE(new HumanoidArm[0]);

        private final Set<HumanoidArm> arms;

        private ArmTarget(HumanoidArm ... arms) {
            EnumSet<HumanoidArm> result = EnumSet.noneOf(HumanoidArm.class);
            result.addAll(Set.of(arms));
            this.arms = result;
        }

        public final boolean hasArm(HumanoidArm arm) {
            return this.arms.contains(arm);
        }
    }
}

