/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.client.AccessoryRendererErrorCache;
import io.wispforest.accessories.client.MPOATVConstructingVertexConsumer;
import io.wispforest.accessories.client.PostEffectBuffer;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import java.awt.Color;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.opengl.GL30;

public class AccessoriesRenderLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final PostEffectBuffer BUFFER = new PostEffectBuffer();
    private static final float increment = 0.1f;
    private static Map<String, Float> brightnessMap = new HashMap<String, Float>();
    private static Map<String, Float> opacityMap = new HashMap<String, Float>();
    private static long lastUpdated20th = 0L;

    public AccessoriesRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AccessoriesScreenBase screenBase;
        boolean shouldUpdate;
        Boolean useCustomerBuffer;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        if (containers.isEmpty()) {
            return;
        }
        Boolean renderingLines = AccessoriesScreen.COLLECT_ACCESSORY_POSITIONS.getValue();
        if (!renderingLines.booleanValue() && !AccessoriesScreen.NOT_VERY_NICE_POSITIONS.isEmpty()) {
            AccessoriesScreen.NOT_VERY_NICE_POSITIONS.clear();
        }
        if ((useCustomerBuffer = AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.getValue()).booleanValue() && multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource.endBatch();
        }
        float scale = (float)(1.0 + 0.5 * (0.75 + Math.sin((double)System.currentTimeMillis() / 250.0)));
        Calendar calendar = Calendar.getInstance();
        long current20th = calendar.getTimeInMillis() / 50L;
        boolean bl = shouldUpdate = lastUpdated20th != current20th;
        if (shouldUpdate) {
            lastUpdated20th = current20th;
        }
        AccessoriesInternalSlot selected = null;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AccessoriesScreenBase && (screen = (screenBase = (AccessoriesScreenBase)screen).getHoveredSlot()) instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot;
            selected = slot = (AccessoriesInternalSlot)screen;
        }
        boolean preventHovering = selected != null && selected.getItem().isEmpty();
        AccessoriesConfig.ScreenOptions_.UnHoveredOptions_ unHoveredOptions = Accessories.config().screenOptions.unHoveredOptions;
        AccessoriesConfig.ScreenOptions_.HoveredOptions_ hoveredOptions = Accessories.config().screenOptions.hoveredOptions;
        boolean isFunnyDate = calendar.get(2) + 1 == 5 && calendar.get(5) == 16;
        for (Map.Entry<String, AccessoriesContainer> entry : containers.entrySet()) {
            AccessoriesContainer container = entry.getValue();
            ExpandedSimpleContainer accessories = container.getAccessories();
            ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
            boolean containerSelected = selected != null && selected.accessoriesContainer.slotType() == container.slotType();
            for (int i = 0; i < accessories.getContainerSize(); ++i) {
                AccessoryRenderer renderer;
                boolean isSelected = containerSelected && selected.getContainerSlot() == i;
                ItemStack stack = accessories.getItem(i);
                ItemStack cosmeticStack = cosmetics.getItem(i);
                if (!cosmeticStack.isEmpty() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmeticStack;
                }
                if (stack.isEmpty() || (renderer = AccessoriesRendererRegistry.getRenderer(stack)).isEmpty() || !renderer.shouldRender(container.shouldRender(i))) continue;
                String mapKey = entry.getKey() + i;
                if (shouldUpdate) {
                    Float currentBrightness = brightnessMap.getOrDefault(mapKey, Float.valueOf(1.0f));
                    Float currentOpacity = opacityMap.getOrDefault(mapKey, Float.valueOf(1.0f));
                    if (selected != null && !isSelected && !preventHovering) {
                        brightnessMap.put(mapKey, Float.valueOf(Math.max(unHoveredOptions.darkenedBrightness(), currentBrightness.floatValue() - 0.1f)));
                        opacityMap.put(mapKey, Float.valueOf(Math.max(unHoveredOptions.darkenedOpacity(), currentOpacity.floatValue() - 0.1f)));
                    } else {
                        brightnessMap.put(mapKey, Float.valueOf(Math.min(1.0f, currentBrightness.floatValue() + 0.1f)));
                        opacityMap.put(mapKey, Float.valueOf(Math.min(1.0f, currentOpacity.floatValue() + 0.1f)));
                    }
                }
                MPOATVConstructingVertexConsumer mpoatv = new MPOATVConstructingVertexConsumer();
                MutableBoolean bufferedGrabbedFlag = new MutableBoolean(false);
                MultiBufferSource innerBufferSource = renderType -> {
                    bufferedGrabbedFlag.setValue(true);
                    return useCustomerBuffer != false ? VertexMultiConsumer.create((VertexConsumer)multiBufferSource.getBuffer(renderType), (VertexConsumer)mpoatv) : multiBufferSource.getBuffer(renderType);
                };
                if (!AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.getValue().booleanValue() || isSelected || selected == null || unHoveredOptions.renderUnHovered()) {
                    poseStack.pushPose();
                    try {
                        renderer.render(stack, SlotReference.of(entity, container.getSlotName(), i), poseStack, this.getParentModel(), innerBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    }
                    catch (Throwable e) {
                        AccessoryRendererErrorCache.logIfTimeAllotted(entity, stack, renderer, e);
                    }
                    poseStack.popPose();
                }
                float[] colorValues = null;
                if (!useCustomerBuffer.booleanValue() || !bufferedGrabbedFlag.getValue().booleanValue()) continue;
                if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                    MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
                    if (hoveredOptions.brightenHovered() && isSelected) {
                        if (isFunnyDate) {
                            float hue = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
                            Color color = new Color(Mth.hsvToRgb((float)hue, (float)1.0f, (float)1.0f));
                            colorValues = new float[]{(float)color.getRed() / 128.0f, (float)color.getGreen() / 128.0f, (float)color.getBlue() / 128.0f, 1.0f};
                        } else {
                            float mul = hoveredOptions.cycleBrightness() ? scale : 1.5f;
                            colorValues = new float[]{mul, mul, mul, 1.0f};
                        }
                    } else if (unHoveredOptions.darkenUnHovered()) {
                        Float darkness = brightnessMap.getOrDefault(mapKey, Float.valueOf(1.0f));
                        colorValues = new float[]{darkness.floatValue(), darkness.floatValue(), darkness.floatValue(), opacityMap.getOrDefault(mapKey, Float.valueOf(1.0f)).floatValue()};
                    }
                    if (colorValues != null) {
                        BUFFER.beginWrite(true, 256);
                        bufferSource.endBatch();
                        BUFFER.endWrite();
                        BUFFER.draw(colorValues);
                        RenderTarget frameBuffer = BUFFER.buffer();
                        GlStateManager._glBindFramebuffer((int)36008, (int)frameBuffer.frameBufferId);
                        GL30.glBlitFramebuffer((int)0, (int)0, (int)frameBuffer.width, (int)frameBuffer.height, (int)0, (int)0, (int)frameBuffer.width, (int)frameBuffer.height, (int)256, (int)9728);
                        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
                    } else {
                        bufferSource.endBatch();
                    }
                }
                if (!renderingLines.booleanValue() || !AccessoriesScreen.IS_RENDERING_LINE_TARGET.getValue().booleanValue()) continue;
                AccessoriesScreen.NOT_VERY_NICE_POSITIONS.put(container.getSlotName() + i, mpoatv.meanPos());
            }
        }
    }
}

