/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.rendering.CustomDataRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.utils.HashUtils;
import io.wispforest.accessories.utils.ManagedEndecDataLoader;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.owo.Owo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Experimental
public class CustomRendererLoader
extends ManagedEndecDataLoader<CustomDataRenderer> {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private ResourceLocation constantResolveTarget = null;
    public static final CustomRendererLoader INSTANCE = new CustomRendererLoader();
    private final Map<ResourceLocation, RenderingFunction.Compound> resolvedClient = new HashMap<ResourceLocation, RenderingFunction.Compound>();
    private final Map<ResourceLocation, RenderingFunction.Compound> resolvedServer = new HashMap<ResourceLocation, RenderingFunction.Compound>();
    private boolean alwaysResolveFlag = false;
    private final Set<ResourceLocation> missingRenderersClient = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> missingRenderersServer = new HashSet<ResourceLocation>();
    private static final Cache<ResourceLocation, Integer> ERROR_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).maximumSize(3000L).build();

    protected CustomRendererLoader() {
        super(Accessories.of("custom_renderer_loader"), "custom_renderer", CustomDataRenderer.ENDEC);
    }

    @Nullable
    public static RenderingFunction getOrResolveRenderer(ResourceLocation id, Map<String, JsonElement> references, Level level) {
        return CustomRendererLoader.getOrResolveRenderer(id, references, level.isClientSide());
    }

    @Nullable
    public static RenderingFunction getOrResolveRenderer(ResourceLocation id, Map<String, JsonElement> references, boolean isClientSide) {
        return INSTANCE.getOrResolveRendererInitial(new ArrayDeque<ResourceLocation>(), id, references, isClientSide);
    }

    @Nullable
    public static RenderingFunction getOrResolveRenderer(CustomDataRenderer dataRenderer, boolean isClientSide) {
        if (!dataRenderer.rendererId().equals((Object)CustomDataRenderer.NO_RENDERER_SELECTED)) {
            return CustomRendererLoader.getOrResolveRenderer(dataRenderer.rendererId(), Map.of(), isClientSide);
        }
        if (dataRenderer.renderingFunctions() != null) {
            return INSTANCE.resolveRawData(new ArrayDeque<ResourceLocation>(), Accessories.of("generated"), dataRenderer, new HashMap<String, JsonElement>(), isClientSide);
        }
        return null;
    }

    @Override
    protected void onSync() {
        this.missingRenderersClient.clear();
        this.missingRenderersServer.clear();
        this.resolvedClient.clear();
        this.resolvedServer.clear();
    }

    @Nullable
    private RenderingFunction.Compound getOrResolveRendererInitial(Deque<ResourceLocation> currentResolveTree, ResourceLocation id, Map<String, JsonElement> references, boolean isClientSide) {
        references = new HashMap<String, JsonElement>(references);
        RenderingFunction.Compound function = null;
        boolean shouldResetFlagOnResolve = false;
        if (Objects.equals(this.constantResolveTarget, id)) {
            if (!this.alwaysResolveFlag) {
                this.alwaysResolveFlag = true;
                shouldResetFlagOnResolve = true;
            }
        } else if (!this.alwaysResolveFlag) {
            function = (isClientSide ? this.resolvedClient : this.resolvedServer).get(id);
        }
        if (function == null) {
            function = this.resolveRenderer(currentResolveTree, id, references, isClientSide);
            (isClientSide ? this.resolvedClient : this.resolvedServer).put(id, function);
        }
        if (shouldResetFlagOnResolve) {
            this.alwaysResolveFlag = false;
        }
        return function;
    }

    private RenderingFunction.Compound resolveRenderer(Deque<ResourceLocation> currentResolveTree, ResourceLocation id, Map<String, JsonElement> references, boolean isClientSide) {
        currentResolveTree.push(id);
        CustomDataRenderer rawRenderer = null;
        if (this.alwaysResolveFlag) {
            rawRenderer = this.getDataFromId(id, isClientSide);
        }
        if (rawRenderer == null) {
            rawRenderer = (CustomDataRenderer)this.getEntry(id, isClientSide);
        }
        if (rawRenderer == null) {
            Set<ResourceLocation> errorSet;
            Set<ResourceLocation> set = errorSet = isClientSide ? this.missingRenderersClient : this.missingRenderersServer;
            if (!errorSet.contains(id)) {
                LOGGER.error("Unable to resolve renderer [{}] as it was not found within Custom Renderer Registry!", (Object)id);
                errorSet.add(id);
            }
            return null;
        }
        RenderingFunction.Compound function = this.resolveRawData(currentResolveTree, id, rawRenderer, references, isClientSide);
        currentResolveTree.pop();
        return function;
    }

    @Nullable
    private RenderingFunction.Compound resolveRawData(Deque<ResourceLocation> currentResolveTree, ResourceLocation id, CustomDataRenderer rawData, Map<String, JsonElement> references, boolean isClientSide) {
        rawData.references().forEach(references::putIfAbsent);
        if (!rawData.rendererId().equals((Object)CustomDataRenderer.NO_RENDERER_SELECTED)) {
            if (currentResolveTree.contains(rawData.rendererId())) {
                currentResolveTree.push(rawData.rendererId());
                LOGGER.error("Recursive loop of Renderer Referencing, unable to resolve such! [{}]", currentResolveTree);
                currentResolveTree.pop();
                return null;
            }
            RenderingFunction.Compound renderingFunc = this.resolveRenderer(currentResolveTree, rawData.rendererId(), references, isClientSide);
            if (renderingFunc != null && rawData.firstPersonArmTarget() != null) {
                renderingFunc = new RenderingFunction.Compound(renderingFunc.renderingFunctions(), rawData.firstPersonArmTarget());
            }
            return renderingFunc;
        }
        if (rawData.renderingFunctions() != null) {
            ArrayList<RenderingFunction> renderers = new ArrayList<RenderingFunction>();
            for (JsonElement rawRenderingFunc : rawData.renderingFunctions()) {
                try {
                    rawRenderingFunc = CustomRendererLoader.resolveReferencesForCopy(references, rawRenderingFunc);
                    RenderingFunction renderingFunc = (RenderingFunction)RenderingFunction.ENDEC.decodeFully(GsonDeserializer::of, (Object)rawRenderingFunc);
                    if (renderingFunc instanceof CustomDataRenderer) {
                        CustomDataRenderer renderer = (CustomDataRenderer)renderingFunc;
                        renderingFunc = this.resolveRawData(currentResolveTree, id.withPrefix("."), renderer, references, isClientSide);
                        if (renderingFunc == null) {
                            LOGGER.warn("Unable to resolve inner renderer [{}] for [{}] as it was not found within Custom Renderer Registry!", (Object)renderer.rendererId(), (Object)id);
                            continue;
                        }
                    }
                    renderers.add(renderingFunc);
                }
                catch (Exception e) {
                    this.errorIfDifferent(id, e, () -> {
                        LOGGER.error("Unable to decode the a given Render Function with [{}] due the following error: ", (Object)id);
                        this.minimalErroring(e);
                    });
                }
            }
            RenderingFunction.ArmTarget armTarget = rawData.firstPersonArmTarget();
            return new RenderingFunction.Compound(Collections.unmodifiableList(renderers), armTarget != null ? armTarget : RenderingFunction.ArmTarget.NONE);
        }
        return null;
    }

    private static JsonElement resolveReferencesForCopy(Map<String, JsonElement> references, JsonElement jsonElement) {
        JsonElement copy = jsonElement.deepCopy();
        CustomRendererLoader.resolveReferences(references, copy);
        return copy;
    }

    private static void resolveReferences(Map<String, JsonElement> references, JsonElement jsonElement) {
        block7: {
            block6: {
                if (!(jsonElement instanceof JsonObject)) break block6;
                JsonObject jsonObject = (JsonObject)jsonElement;
                for (Map.Entry entry : jsonObject.asMap().entrySet()) {
                    String possibleReference;
                    JsonPrimitive jsonPrimitive;
                    String key = (String)entry.getKey();
                    JsonElement childElement = (JsonElement)entry.getValue();
                    if (childElement instanceof JsonObject) {
                        JsonObject innerJsonObject = (JsonObject)childElement;
                        CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonObject);
                        continue;
                    }
                    if (childElement instanceof JsonArray) {
                        JsonArray innerJsonArray = (JsonArray)childElement;
                        CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonArray);
                        continue;
                    }
                    if (!(childElement instanceof JsonPrimitive) || !(jsonPrimitive = (JsonPrimitive)childElement).isString() || !(possibleReference = jsonPrimitive.getAsString()).matches("#.*") || !references.containsKey(possibleReference)) continue;
                    jsonObject.add(key, references.get(possibleReference));
                }
                break block7;
            }
            if (!(jsonElement instanceof JsonArray)) break block7;
            JsonArray jsonArray = (JsonArray)jsonElement;
            List list = jsonArray.asList();
            for (int i = 0; i < list.size(); ++i) {
                String possibleReference;
                JsonPrimitive jsonPrimitive;
                JsonElement childElement = (JsonElement)list.get(i);
                if (childElement instanceof JsonObject) {
                    JsonObject innerJsonObject = (JsonObject)childElement;
                    CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonObject);
                    continue;
                }
                if (childElement instanceof JsonArray) {
                    JsonArray innerJsonArray = (JsonArray)childElement;
                    CustomRendererLoader.resolveReferences(references, (JsonElement)innerJsonArray);
                    continue;
                }
                if (!(childElement instanceof JsonPrimitive) || !(jsonPrimitive = (JsonPrimitive)childElement).isString() || !(possibleReference = jsonPrimitive.getAsString()).matches("#.*") || !references.containsKey(possibleReference)) continue;
                jsonArray.set(i, references.get(possibleReference));
            }
        }
    }

    @ApiStatus.Internal
    public static void constantFileResolving(MinecraftServer server, ResourceLocation id) {
        if (server.isDedicatedServer() && Accessories.DEBUG) {
            return;
        }
        CustomRendererLoader.INSTANCE.constantResolveTarget = id;
    }

    public static boolean isConstantResolveTarget() {
        return CustomRendererLoader.INSTANCE.constantResolveTarget != null;
    }

    @Nullable
    protected CustomDataRenderer getDataFromId(ResourceLocation id, boolean isClientSide) {
        ResourceLocation fileId = FileToIdConverter.json((String)this.type).idToFile(id);
        ResourceManager resource = this.getResourceManager(isClientSide);
        if (resource != null) {
            try {
                JsonElement element;
                try (BufferedReader reader = resource.openAsReader(fileId);){
                    element = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                }
                return (CustomDataRenderer)this.endec.decodeFully(GsonDeserializer::of, (Object)element);
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                this.errorIfDifferent(id, e, () -> this.lambda$getDataFromId$1(id, fileId, (Exception)e));
            }
        }
        return null;
    }

    private void minimalErroring(Throwable throwable) {
        if (!this.alwaysResolveFlag) {
            LOGGER.error("", throwable);
            return;
        }
        if (throwable.getCause() != null) {
            this.minimalErroring(throwable.getCause());
        }
        LOGGER.error(throwable.getMessage());
    }

    private void errorIfDifferent(ResourceLocation id, Throwable e, Runnable runnable) {
        if (!this.alwaysResolveFlag) {
            runnable.run();
            return;
        }
        Integer prevErrorHash = (Integer)ERROR_CACHE.getIfPresent((Object)id);
        int hash = HashUtils.getHash(e);
        if (!Objects.equals(hash, prevErrorHash)) {
            ERROR_CACHE.put((Object)id, (Object)hash);
            runnable.run();
        }
    }

    @NotNull
    private ResourceManager getResourceManager(boolean isClientSide) {
        if (!isClientSide) {
            return Owo.currentServer().getResourceManager();
        }
        return this.getClientManger();
    }

    @OnlyIn(value=Dist.CLIENT)
    private ResourceManager getClientManger() {
        return Minecraft.getInstance().getResourceManager();
    }

    public static void init() {
    }

    private /* synthetic */ void lambda$getDataFromId$1(ResourceLocation id, ResourceLocation fileId, Exception e) {
        LOGGER.error("Couldn't parse data file {} from {}", (Object)id, (Object)fileId);
        this.minimalErroring(e);
    }
}

