/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.api;

import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.ICylinderBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface ISimpleChoppableBlock
extends IChoppableBlock,
ICylinderBlock {
    @Override
    default public int getRadius(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return 8;
    }

    @Override
    default public void chop(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState, int numChops, boolean felling) {
        ResourceLocation CHOPPED_LOG = ResourceLocation.fromNamespaceAndPath((String)"treechop", (String)"chopped_log");
        Block choppedLog = (Block)BuiltInRegistries.BLOCK.get(CHOPPED_LOG);
        if (choppedLog instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)choppedLog;
            choppableBlock.chop(player, tool, level, pos, blockState, numChops, felling);
        }
    }

    @Override
    default public int getNumChops(BlockGetter level, BlockPos pos, BlockState blockState) {
        return 0;
    }

    @Override
    default public int getMaxNumChops(BlockGetter level, BlockPos pos, BlockState blockState) {
        return this.getRadius(level, pos, blockState) - 1;
    }

    @Override
    default public double getSupportFactor(BlockGetter level, BlockPos pos, BlockState blockState) {
        return (double)this.getRadius(level, pos, blockState) / 8.0;
    }
}

