/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.TreeChop;
import ht.treechop.client.gui.screen.ClientSettingsScreen;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ClientRequestSettingsPacket;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import ht.treechop.common.util.TreeCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class Client {
    protected static final Permissions serverPermissions = new Permissions();
    public static TreeCache treeCache = new TreeCache();
    protected static Client instance;
    protected static final ClientChopSettings chopSettings;

    public static void requestSetting(SettingsField field, Object value) {
        Client.instance().sendToServer(new ClientRequestSettingsPacket(field, value));
    }

    public static void toggleChopping() {
        boolean newValue = chopSettings.get(SettingsField.CHOPPING, Boolean.class) == false;
        chopSettings.set(SettingsField.CHOPPING, newValue);
    }

    public static void cycleSneakBehavior() {
        SneakBehavior newValue = chopSettings.getSneakBehavior() == SneakBehavior.NONE ? SneakBehavior.INVERT_CHOPPING : SneakBehavior.NONE;
        chopSettings.set(SettingsField.SNEAK_BEHAVIOR, (Object)newValue);
    }

    public static ClientChopSettings getChopSettings() {
        return chopSettings;
    }

    public static void setChoppingIndicatorVisibility(boolean showChoppingIndicator) {
        ConfigHandler.CLIENT.showChoppingIndicators.set((Object)showChoppingIndicator);
    }

    public static boolean isChoppingIndicatorEnabled() {
        return (Boolean)ConfigHandler.CLIENT.showChoppingIndicators.get();
    }

    public static void toggleSettingsOverlay() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen instanceof ClientSettingsScreen) {
            minecraft.screen.onClose();
        } else {
            minecraft.setScreen((Screen)new ClientSettingsScreen());
        }
    }

    public static void updatePermissions(Permissions permissions) {
        serverPermissions.copy(permissions);
    }

    public static Permissions getServerPermissions() {
        return serverPermissions;
    }

    public static Client instance() {
        return instance;
    }

    protected static void syncOnJoin() {
        TreeChop.LOGGER.info("Sending chop settings sync request");
        chopSettings.copyFrom(ConfigHandler.CLIENT.getChopSettings());
        Client.instance().sendToServer(new ClientRequestSettingsPacket(chopSettings));
    }

    public static void handleUpdateChopsPacket(BlockPos pos, CompoundTag tag) {
        BlockEntity blockEntity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (blockEntity = level.getBlockEntity(pos)) instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            entity.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
        }
    }

    public static Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    public abstract void sendToServer(CustomPacketPayload var1);

    static {
        chopSettings = new ClientChopSettings(){

            @Override
            public ChopSettings set(SettingsField field, Object value) {
                treeCache.invalidate();
                return super.set(field, value);
            }
        };
    }
}

