/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.TreeChop;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.common.NeoForgeRegistry;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.block.NeoForgeChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.properties.ChoppedLogShape;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeChoppedLogBakedModel
extends ChoppedLogBakedModel
implements IDynamicBakedModel {
    public static ModelProperty<Map<Direction, BlockState>> STRIPPED_NEIGHBORS = new ModelProperty();
    public static ModelProperty<BlockState> STRIPPED_BLOCK_STATE = new ModelProperty();
    public static ModelProperty<Integer> RADIUS = new ModelProperty();
    public static ModelProperty<ChoppedLogShape> CHOPPED_LOG_SHAPE = new ModelProperty();

    public static void overrideBlockStateModels(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation oakLog = BlockModelShaper.stateToModelLocation((BlockState)Blocks.OAK_LOG.defaultBlockState());
        NeoForgeChoppedLogBakedModel.setDefaultSprite(((BakedModel)event.getModels().get(oakLog)).getParticleIcon());
        for (BlockState blockState : ((NeoForgeChoppedLogBlock)NeoForgeRegistry.Blocks.CHOPPED_LOG.get()).getStateDefinition().getPossibleStates()) {
            ModelResourceLocation variantMRL = BlockModelShaper.stateToModelLocation((BlockState)blockState);
            BakedModel existingModel = (BakedModel)event.getModels().get(variantMRL);
            if (existingModel == null) {
                TreeChop.LOGGER.warn("Did not find the expected vanilla baked model(s) for treechop:chopped_log in registry");
                continue;
            }
            if (existingModel instanceof NeoForgeChoppedLogBakedModel) {
                TreeChop.LOGGER.warn("Tried to replace ChoppedLogBakedModel twice");
                continue;
            }
            NeoForgeChoppedLogBakedModel customModel = new NeoForgeChoppedLogBakedModel();
            event.getModels().put(variantMRL, customModel);
        }
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RENDER_TYPE});
    }

    @Nonnull
    public static ModelData getModelData(ChoppedLogBlock.MyEntity entity) {
        BlockState strippedState = ChopUtil.getStrippedState((BlockAndTintGetter)entity.getLevel(), entity.getBlockPos(), entity.getOriginalState());
        ModelData.Builder builder = ModelData.builder();
        builder.with(STRIPPED_NEIGHBORS, NeoForgeChoppedLogBakedModel.getStrippedNeighbors((BlockAndTintGetter)entity.getLevel(), entity.getBlockPos(), entity));
        builder.with(STRIPPED_BLOCK_STATE, (Object)strippedState);
        builder.with(RADIUS, (Object)entity.getRadius());
        builder.with(CHOPPED_LOG_SHAPE, (Object)entity.getShape());
        return builder.build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (side == null) {
            BlockState strippedState = this.or((BlockState)extraData.get(STRIPPED_BLOCK_STATE), Blocks.STRIPPED_OAK_LOG.defaultBlockState());
            Map<Direction, BlockState> strippedNeighbors = this.or((Map)extraData.get(STRIPPED_NEIGHBORS), Collections.emptyMap());
            ChoppedLogShape shape = this.or((ChoppedLogShape)((Object)extraData.get(CHOPPED_LOG_SHAPE)), ChoppedLogShape.PILLAR_Y);
            int radius = this.or((Integer)extraData.get(RADIUS), 8);
            return this.getQuads(strippedState, shape, radius, rand, strippedNeighbors).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BlockState strippedState = this.or((BlockState)data.get(STRIPPED_BLOCK_STATE), Blocks.STRIPPED_OAK_LOG.defaultBlockState());
        return NeoForgeChoppedLogBakedModel.getBlockModel(strippedState).getParticleIcon();
    }

    private <T> T or(T value, T fallback) {
        return value != null ? value : fallback;
    }
}

