/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.api.world.randomize;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ItemRandomizer {
    public static final Codec<ItemRandomizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(randomizer -> randomizer.entries), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("defaultItem").forGetter(randomizer -> randomizer.defaultItem)).apply((Applicative)instance, ItemRandomizer::new));
    private List<Entry> entries = new ArrayList<Entry>();
    private Item defaultItem = Items.AIR;

    public CompoundTag saveTag() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("defaultItemId", BuiltInRegistries.ITEM.getId((Object)this.defaultItem));
        ListTag entriesTag = (ListTag)Util.make((Object)new ListTag(), tag -> this.entries.forEach(entry -> {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putInt("entryItemId", BuiltInRegistries.ITEM.getId((Object)entry.item));
            entryTag.putFloat("entryChance", entry.probability);
            tag.add((Object)entryTag);
        }));
        compoundTag.put("entries", (Tag)entriesTag);
        return compoundTag;
    }

    public ItemRandomizer(CompoundTag compoundTag) {
        this.defaultItem = (Item)BuiltInRegistries.ITEM.byId(compoundTag.getInt("defaultItemId"));
        this.entries = new ArrayList<Entry>();
        ListTag entriesTag = compoundTag.getList("entries", 10);
        entriesTag.forEach(entryTag -> {
            CompoundTag entryCompoundTag = (CompoundTag)entryTag;
            Item item = (Item)BuiltInRegistries.ITEM.byId(entryCompoundTag.getInt("entryItemId"));
            float chance = entryCompoundTag.getFloat("entryChance");
            this.addItem(item, chance);
        });
    }

    public ItemRandomizer(List<Entry> entries, Item defaultItem) {
        this.entries = entries;
        this.defaultItem = defaultItem;
    }

    public ItemRandomizer(Item defaultItem) {
        this.defaultItem = defaultItem;
    }

    public ItemRandomizer() {
    }

    public static ItemRandomizer from(Item ... items) {
        ItemRandomizer randomizer = new ItemRandomizer();
        float chance = 1.0f / (float)items.length;
        for (Item item : items) {
            randomizer.addItem(item, chance);
        }
        return randomizer;
    }

    public ItemRandomizer addItem(Item item, float chance) {
        if (this.entries.stream().anyMatch(entry -> entry.item.equals(item))) {
            YungsApiCommon.LOGGER.warn("WARNING: duplicate item {} added to ItemRandomizer!", (Object)item.toString());
            return this;
        }
        float currTotal = this.entries.stream().map(entry -> Float.valueOf(entry.probability)).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApiCommon.LOGGER.warn("WARNING: item {} added to ItemRandomizer exceeds max probabiltiy of 1!", (Object)item.toString());
            return this;
        }
        this.entries.add(new Entry(item, chance));
        return this;
    }

    public Item get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.item;
            }
            currBottom += entry.probability;
        }
        return this.defaultItem;
    }

    public Item get(RandomSource randomSource) {
        float target = randomSource.nextFloat();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.item;
            }
            currBottom += entry.probability;
        }
        return this.defaultItem;
    }

    public void setDefaultItem(Item item) {
        this.defaultItem = item;
    }

    public Map<Item, Float> getEntriesAsMap() {
        HashMap<Item, Float> map = new HashMap<Item, Float>();
        this.entries.forEach(entry -> map.put(entry.item, Float.valueOf(entry.probability)));
        return map;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Item getDefaultItem() {
        return this.defaultItem;
    }

    public static class Entry {
        public static Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(entry -> entry.item), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(entry -> Float.valueOf(entry.probability))).apply((Applicative)instance, Entry::new));
        public Item item;
        public float probability;

        public Entry(Item item, float probability) {
            this.item = item;
            this.probability = probability;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.item.equals(((Entry)obj).item);
            }
            if (obj instanceof Item) {
                return this.item.equals(obj);
            }
            return false;
        }
    }
}

