/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class RibbitApplyBuffGoal
extends Goal {
    private static final int TICKS_UNTIL_BUFF_APPLIED = 22;
    private final RibbitEntity ribbit;
    private final double range;
    private final int cooldownTicks;
    private final Map<Holder<MobEffect>, Integer> effects;
    private int ticksSinceStart;

    public RibbitApplyBuffGoal(RibbitEntity ribbit, double range, int cooldownTicks) {
        this.ribbit = ribbit;
        this.range = range;
        this.cooldownTicks = cooldownTicks;
        this.effects = new HashMap<Holder<MobEffect>, Integer>();
        this.effects.put((Holder<MobEffect>)MobEffects.REGENERATION, 1200);
        this.effects.put((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 2400);
        this.effects.put((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 2400);
        this.effects.put((Holder<MobEffect>)MobEffects.JUMP, 2400);
        this.effects.put((Holder<MobEffect>)MobEffects.DIG_SPEED, 2400);
        this.effects.put((Holder<MobEffect>)MobEffects.HEALTH_BOOST, 2400);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.ribbit.getBuffCooldown() == 0 && !this.ribbit.level().getNearbyPlayers(TargetingConditions.forCombat().range(this.range), (LivingEntity)this.ribbit, this.ribbit.getBoundingBox().inflate(this.range, 5.0, this.range)).isEmpty();
    }

    public boolean canContinueToUse() {
        return this.ticksSinceStart >= 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.ticksSinceStart >= 22) {
            this.applyBuffs();
        } else if (this.ticksSinceStart >= 0) {
            ++this.ticksSinceStart;
        }
    }

    public void start() {
        this.ticksSinceStart = 0;
        this.ribbit.setBuffing(true);
        this.ribbit.playSound((SoundEvent)SoundModule.ENTITY_RIBBIT_MAGIC.get());
    }

    public void stop() {
        this.ribbit.setBuffCooldown(this.cooldownTicks);
        this.ticksSinceStart = 0;
    }

    public boolean isInterruptable() {
        return false;
    }

    private void applyBuffs() {
        this.ticksSinceStart = -1;
        List nearbyPlayers = this.ribbit.level().getNearbyPlayers(TargetingConditions.forCombat().range(this.range), (LivingEntity)this.ribbit, this.ribbit.getBoundingBox().inflate(this.range, 5.0, this.range));
        Holder randomEffect = (Holder)this.effects.keySet().stream().toList().get(this.ribbit.getRandom().nextInt(this.effects.size()));
        int effectDuration = this.effects.get(randomEffect);
        for (Player player : nearbyPlayers) {
            player.addEffect(new MobEffectInstance(randomEffect, effectDuration, 0));
        }
        this.ribbit.setBuffing(false);
    }
}

