/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.entity.neoforge;

import com.chefmooon.ubesdelight.common.block.entity.BakingMatBlockEntity;
import com.chefmooon.ubesdelight.common.block.neoforge.BakingMatBlockImpl;
import com.chefmooon.ubesdelight.common.crafting.neoforge.BakingMatRecipeImpl;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.chefmooon.ubesdelight.common.registry.neoforge.UbesDelightBlockEntityTypesImpl;
import com.chefmooon.ubesdelight.common.registry.neoforge.UbesDelightRecipeTypesImpl;
import com.chefmooon.ubesdelight.common.tag.CommonTags;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

@EventBusSubscriber(modid="ubesdelight", bus=EventBusSubscriber.Bus.MOD)
public class BakingMatBlockEntityImpl
extends SyncedBlockEntity {
    public static final int MAX_INGREDIENTS = 9;
    public static final int MAX_PROCESSING_STAGES = 5;
    public static final int MAX_RESULTS = 4;
    private final ItemStackHandler inventory = this.createHandler();
    private final RecipeManager.CachedCheck<RecipeWrapper, BakingMatRecipeImpl> quickCheck = RecipeManager.createCheck(UbesDelightRecipeTypesImpl.BAKING_MAT.get());

    public BakingMatBlockEntityImpl(BlockPos pos, BlockState state) {
        super((BlockEntityType)UbesDelightBlockEntityTypesImpl.BAKING_MAT_BAMBOO.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    public boolean processItemUsingTool(ItemStack tool, @Nullable Player player) {
        if (this.level == null) {
            return false;
        }
        Optional<RecipeHolder<BakingMatRecipeImpl>> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandler)this.inventory), tool, player);
        matchingRecipe.ifPresent(recipe -> {
            NonNullList<Ingredient> processStages = ((BakingMatRecipeImpl)recipe.value()).getProcessStages();
            List<ItemStack> ingredientContainers = this.getInventoryContainers(this.inventory);
            BlockPos blockPos = this.getBlockPos();
            if (!((BakingMatRecipeImpl)recipe.value()).getProcessStages().isEmpty()) {
                if (!((Boolean)this.getBlockState().getValue((Property)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    if (!ingredientContainers.isEmpty()) {
                        this.spawnResults(ingredientContainers);
                    }
                    this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(true)));
                    this.clearInventory();
                    ItemStack itemStack = Arrays.stream(((Ingredient)processStages.get(0)).getItems()).findFirst().orElse(ItemStack.EMPTY);
                    this.inventory.setStackInSlot(0, itemStack);
                    BakingMatBlockEntityImpl.spawnParticles(this.level, this.getBlockPos(), itemStack, 5);
                    this.inventoryChanged();
                } else if (((Boolean)this.getBlockState().getValue((Property)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    int currentStage = this.getProcessStage(this.inventory.getStackInSlot(0), (List<Ingredient>)processStages);
                    if (currentStage < ((BakingMatRecipeImpl)recipe.value()).getProcessStages().size() - 1) {
                        ItemStack currentStageItem = this.inventory.getStackInSlot(0);
                        int nextStage = this.getNextProcessStage(currentStageItem, (List<Ingredient>)processStages);
                        if (!((Ingredient)processStages.get(nextStage)).isEmpty()) {
                            this.clearInventory();
                            ItemStack nextStageItem = Arrays.stream(((Ingredient)processStages.get(nextStage)).getItems()).findFirst().orElse(ItemStack.EMPTY);
                            BakingMatBlockEntityImpl.spawnParticles(this.level, this.getBlockPos(), nextStageItem, 5);
                            this.inventory.setStackInSlot(0, nextStageItem);
                            this.inventoryChanged();
                        }
                    } else if (currentStage == ((BakingMatRecipeImpl)recipe.value()).getProcessStages().size() - 1) {
                        this.spawnRolledResults((BakingMatRecipeImpl)recipe.value(), blockPos, this.level, tool, null);
                        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                this.spawnRolledResults((BakingMatRecipeImpl)recipe.value(), blockPos, this.level, tool, ingredientContainers);
            }
            BakingMatBlockEntity.triggerAdvancement(player);
            if (!this.level.isClientSide) {
                tool.hurtAndBreak(1, (ServerLevel)this.level, (ServerPlayer)player, item -> {});
            }
            this.playProcessingSound(((BakingMatRecipeImpl)recipe.value()).getSoundEvent().orElse(null), tool);
        });
        return matchingRecipe.isPresent();
    }

    private Optional<RecipeHolder<BakingMatRecipeImpl>> getMatchingRecipe(RecipeWrapper inventoryWrapper, ItemStack toolStack, @Nullable Player player) {
        if (this.level == null) {
            return Optional.empty();
        }
        Optional recipe = this.quickCheck.getRecipeFor((RecipeInput)inventoryWrapper, this.level);
        if (recipe.isPresent()) {
            if (((BakingMatRecipeImpl)((RecipeHolder)recipe.get()).value()).getTool().test(toolStack)) {
                return recipe;
            }
            if (player != null) {
                player.displayClientMessage((Component)TextUtils.getTranslatable("tooltip.baking_mat.invalid_tool", new Object[0]), true);
            }
        } else if (player != null) {
            player.displayClientMessage((Component)TextUtils.getTranslatable("tooltip.baking_mat.invalid_item", new Object[0]), true);
        }
        return Optional.empty();
    }

    private void spawnRolledResults(BakingMatRecipeImpl recipe, BlockPos blockPos, Level level, ItemStack tool, @Nullable List<ItemStack> containers) {
        List<ItemStack> results = recipe.getRollResults(level.random, EnchantmentHelper.getTagEnchantmentLevel((Holder)((Holder)level.holder(Enchantments.FORTUNE).get()), (ItemStack)tool));
        if (containers != null && !containers.isEmpty()) {
            results.addAll(containers);
        }
        if (!results.isEmpty()) {
            BakingMatBlockEntityImpl.spawnParticles(level, blockPos, results.get(0).copy(), 5);
            this.spawnResults(results);
            this.clearInventory();
        }
    }

    private void spawnResults(List<ItemStack> results) {
        for (ItemStack result : results) {
            Direction direction = ((Direction)this.getBlockState().getValue((Property)BakingMatBlockImpl.FACING)).getCounterClockWise();
            ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.2, (double)this.worldPosition.getY() + 0.2, (double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.2, result.copy());
            entity.setDeltaMovement((double)((float)direction.getStepX() * 0.2f), 0.0, (double)((float)direction.getStepZ() * 0.2f));
            this.level.addFreshEntity((Entity)entity);
        }
    }

    private void playProcessingSound(SoundEvent soundEvent, ItemStack tool) {
        this.playProcessingSound(soundEvent, tool, null);
    }

    private void playProcessingSound(@Nullable SoundEvent soundEvent, ItemStack tool, @Nullable ItemStack item) {
        if (soundEvent != null) {
            this.playSound(soundEvent, 1.0f, 1.0f);
        } else if (tool.is(CommonTags.C_TOOLS_ROLLING_PIN)) {
            this.playSound(UbesDelightSounds.BLOCK_BAKING_MAT_ROLLING_PIN.get(), 1.0f, 0.8f);
        }
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.level != null) {
            this.level.playSound(null, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public static void spawnParticles(Level level, BlockPos pos, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)level.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)level.random.nextFloat() - 0.5) * 0.1);
            if (level instanceof ServerLevel) {
                ((ServerLevel)level).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.1f), (double)((float)pos.getZ() + 0.5f), 1, vec3d.x, vec3d.y + 0.05, vec3d.z, 0.0);
                continue;
            }
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.1f), (double)((float)pos.getZ() + 0.5f), vec3d.x, vec3d.y + 0.05, vec3d.z);
        }
    }

    private Integer getProcessStage(ItemStack itemStack, List<Ingredient> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).isEmpty()) continue;
            if (itemStack.is(Arrays.stream(processStages.get(i).getItems()).findFirst().get().getItem())) {
                return stage;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private Integer getNextProcessStage(ItemStack itemStack, List<Ingredient> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).isEmpty()) continue;
            if (itemStack.is(Arrays.stream(processStages.get(i).getItems()).findFirst().get().getItem())) {
                if (i == processStages.size() - 1) {
                    return stage;
                }
                return stage + 1;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private List<ItemStack> getInventoryContainers(ItemStackHandler inventory) {
        ArrayList<ItemStack> ingredientContainers = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.isEmpty() || itemStack.getCraftingRemainingItem().is(Items.AIR)) continue;
            ingredientContainers.add(itemStack.getCraftingRemainingItem());
        }
        return ingredientContainers;
    }

    public void clearInventory() {
        for (int i = 0; i < 9; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void setInventory(NonNullList<ItemStack> list) {
        for (int i = 0; i < 8; ++i) {
            this.inventory.setStackInSlot(i, (ItemStack)list.get(i));
        }
    }

    public int getContainerSize() {
        return 9;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 9; ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return items;
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public boolean isFull() {
        return !this.inventory.getStackInSlot(8).isEmpty();
    }

    public boolean addItem(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack inventoryStack = this.inventory.getStackInSlot(i);
            if (!inventoryStack.isEmpty()) continue;
            this.inventory.setStackInSlot(i, itemStack.split(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        for (int i = 8; i >= 0; --i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            this.inventoryChanged();
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public int getItemsQuantity() {
        int items = 0;
        for (int i = 0; i <= 8; ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            ++items;
        }
        return items;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public Vec2 getItemOffset(int index) {
        return BakingMatBlockEntity.getItemOffset(index);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)UbesDelightBlockEntityTypesImpl.BAKING_MAT_BAMBOO.get(), (be, context) -> be.getInventory());
    }

    public void setRemoved() {
        super.setRemoved();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BakingMatBlockEntityImpl.this.inventoryChanged();
            }
        };
    }
}

