/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.neoforge;

import com.chefmooon.ubesdelight.common.block.BakingMatBlock;
import com.chefmooon.ubesdelight.common.block.entity.neoforge.BakingMatBlockEntityImpl;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BakingMatBlockImpl
extends BakingMatBlock {
    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BakingMatBlockEntityImpl) {
            BakingMatBlockEntityImpl bakingMatBlockEntity = (BakingMatBlockEntityImpl)blockEntity;
            return bakingMatBlockEntity.getItemsQuantity();
        }
        return 0;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BakingMatBlockEntityImpl)) {
            return result;
        }
        BakingMatBlockEntityImpl bakingMatBlockEntity = (BakingMatBlockEntityImpl)blockEntity;
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack offHandStack = player.getOffhandItem();
        if (heldStack.getItem() instanceof ShearsItem || heldStack.getItem() instanceof TridentItem) {
            return result;
        }
        boolean isValidTool = heldStack.getItem() instanceof DiggerItem;
        if (!bakingMatBlockEntity.isEmpty() && !heldStack.isEmpty() && isValidTool && this.tryProcessBakingMatUsingToolInHand(level, bakingMatBlockEntity, heldStack, offHandStack, player, hand).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)BakingMatBlock.PROCESSING)).booleanValue() && !isValidTool) {
            if (!bakingMatBlockEntity.isFull() && !heldStack.isEmpty()) {
                return this.tryAddItemFromPlayerHand(level, bakingMatBlockEntity, heldStack, offHandStack, player, hand);
            }
            if (hand.equals((Object)InteractionHand.MAIN_HAND) && !bakingMatBlockEntity.isEmpty() && heldStack.isEmpty()) {
                return this.tryRemoveItemFromPlayerHand(level, bakingMatBlockEntity, heldStack, offHandStack, player, hand);
            }
        }
        return result;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof BakingMatBlockEntityImpl) {
            BakingMatBlockEntityImpl bakingMat = (BakingMatBlockEntityImpl)tileEntity;
            if (!((Boolean)state.getValue((Property)PROCESSING)).booleanValue()) {
                Containers.dropContents((Level)level, (BlockPos)pos, bakingMat.getItems());
            } else {
                state.setValue((Property)PROCESSING, (Comparable)Boolean.valueOf(false));
            }
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private ItemInteractionResult tryAddItemFromPlayerHand(Level level, BakingMatBlockEntityImpl bakingMatBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        ItemInteractionResult result = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        if (heldStack.isEmpty()) {
            return result;
        }
        if (bakingMatBlockEntity.addItem(player.getAbilities().instabuild ? heldStack.copy() : heldStack)) {
            level.playSound(null, bakingMatBlockEntity.getBlockPos(), UbesDelightSounds.BLOCK_BAKING_MAT_ADD.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        return result;
    }

    private ItemInteractionResult tryRemoveItemFromPlayerHand(Level level, BakingMatBlockEntityImpl bakingMatBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        BlockPos pos = bakingMatBlockEntity.getBlockPos();
        if (!bakingMatBlockEntity.isEmpty()) {
            if (player.isCreative()) {
                bakingMatBlockEntity.removeItem();
            } else if (!player.getInventory().add(bakingMatBlockEntity.removeItem())) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)bakingMatBlockEntity.removeItem());
            }
            level.playSound(null, bakingMatBlockEntity.getBlockPos(), UbesDelightSounds.BLOCK_BAKING_MAT_REMOVE.get(), SoundSource.BLOCKS, 0.25f, 0.5f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private ItemInteractionResult tryProcessBakingMatUsingToolInHand(Level level, BakingMatBlockEntityImpl bakingMatBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        ItemInteractionResult result = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        if (heldStack.getItem() instanceof DiggerItem && bakingMatBlockEntity.processItemUsingTool(heldStack, player)) {
            return ItemInteractionResult.SUCCESS;
        }
        return result;
    }
}

