/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.item;

import com.chefmooon.ubesdelight.common.Configuration;
import com.chefmooon.ubesdelight.common.block.GlassCupBlock;
import com.chefmooon.ubesdelight.common.item.UbesDelightBlockItem;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class UbesDelightDrinkableBlockItem
extends UbesDelightBlockItem {
    public UbesDelightDrinkableBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        super(block, properties, hasFoodEffectTooltip, hasCustomTooltip);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.isClientSide) {
            this.affectConsumer(stack, level, consumer);
        }
        ItemStack containerStack = new ItemStack((ItemLike)Objects.requireNonNull(stack.getItem().getCraftingRemainingItem()));
        if (stack.get(DataComponents.FOOD) != null) {
            super.finishUsingItem(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
        if (stack.isEmpty()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).getAbilities().instabuild && !player.getInventory().add(containerStack)) {
                player.drop(containerStack, false);
            }
        }
        return stack;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player == null || !player.isShiftKeyDown()) return InteractionResult.FAIL;
        BlockPlaceContext blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.getPlacementState(blockPlaceContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        Level level = blockPlaceContext.getLevel();
        ItemStack itemStack = blockPlaceContext.getItemInHand();
        BlockState blockState2 = level.getBlockState(blockPos);
        Block block = blockState2.getBlock();
        if (!(block instanceof GlassCupBlock)) return super.place(context);
        GlassCupBlock glassCupBlock = (GlassCupBlock)block;
        if (!itemStack.is(glassCupBlock.servingItem.get())) return super.place(context);
        glassCupBlock.addServingFromHand(level, blockPos, blockState2, player, player.getUsedItemHand());
        return InteractionResult.FAIL;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (Configuration.isFoodEffectTooltip()) {
            if (this.hasCustomTooltip) {
                tooltip.add((Component)TextUtils.getTranslatable("tooltip.glass_cup", new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (this.hasFoodEffectTooltip) {
                vectorwing.farmersdelight.common.utility.TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
            }
        }
    }
}

