/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client;

import com.github.x3r.mekanism_weaponry.MekanismWeaponry;
import com.github.x3r.mekanism_weaponry.client.ArmPoses;
import com.github.x3r.mekanism_weaponry.client.renderer.PlasmaRenderer;
import com.github.x3r.mekanism_weaponry.client.renderer.RodRenderer;
import com.github.x3r.mekanism_weaponry.client.screen.WeaponWorkbenchScreen;
import com.github.x3r.mekanism_weaponry.client.skin.PlayerSkinService;
import com.github.x3r.mekanism_weaponry.common.item.AmmoGunItem;
import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.item.HeatGunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.packet.DeactivateGunPayload;
import com.github.x3r.mekanism_weaponry.common.packet.ReloadGunPayload;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.EntityRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.ItemRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.MenuTypeRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.ParticleRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="mekanism_weaponry", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    @Nullable
    private static ShaderInstance rendertypeElectricityShader;
    public static final Lazy<KeyMapping> RELOAD_MAPPING;
    private static float recoilO;
    private static float recoil;
    private static float scopeScale;

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        IEventBus neoEventBus = NeoForge.EVENT_BUS;
        neoEventBus.addListener(ClientSetup::pressKey);
        neoEventBus.addListener(ClientSetup::onClientTick);
        neoEventBus.addListener(ClientSetup::cameraSetupEvent);
        neoEventBus.addListener(ClientSetup::renderGui);
        neoEventBus.addListener(ClientSetup::computeFov);
        PlayerSkinService.reloadCachedSkins();
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        GunItem item;
        Item item2;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        while (((KeyMapping)RELOAD_MAPPING.get()).consumeClick()) {
            if (!(stack.getItem() instanceof GunItem)) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new ReloadGunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!mc.options.keyAttack.isDown() && (item2 = stack.getItem()) instanceof GunItem && (item = (GunItem)item2).isShooting(stack)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new DeactivateGunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        recoilO = recoil;
        if (recoil > 0.0f && (double)(recoil = Mth.sqrt((float)recoil)) < 0.01) {
            recoil = 0.0f;
        }
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.PLASMA.get(), PlasmaRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ROD.get(), RodRenderer::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }, new Item[]{(Item)ItemRegistry.PLASMA_RIFLE.get(), (Item)ItemRegistry.RAILGUN.get()});
        event.registerItem(new IClientItemExtensions(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return (HumanoidModel.ArmPose)ArmPoses.MINIGUN_POSE.getValue();
            }
        }, new Item[]{(Item)ItemRegistry.TESLA_MINIGUN.get()});
    }

    public static void pressKey(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack stack = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
        if (event.isAttack() && stack.getItem() instanceof GunItem) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)RELOAD_MAPPING.get());
    }

    public static void addRecoil(int i) {
        recoil += (float)i;
    }

    public static void cameraSetupEvent(ViewportEvent.ComputeCameraAngles event) {
        if (recoil > 0.0f) {
            event.setPitch((float)((double)event.getPitch() - Mth.lerp((double)event.getPartialTick(), (double)recoilO, (double)recoil)));
        }
    }

    @SubscribeEvent
    public static void registerItemDecorators(RegisterItemDecorationsEvent event) {
        event.register((ItemLike)ItemRegistry.PLASMA_RIFLE.get(), HeatGunItem.decorator());
        event.register((ItemLike)ItemRegistry.RAILGUN.get(), AmmoGunItem.decorator());
        event.register((ItemLike)ItemRegistry.TESLA_MINIGUN.get(), HeatGunItem.decorator());
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)MenuTypeRegistry.WEAPON_WORKBENCH.get(), WeaponWorkbenchScreen::new);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.ROD_TRAIL.get(), ParticleRegistry.RodTrailParticleProvider::new);
    }

    @SubscribeEvent
    public static void registerRenderTypes(RegisterShadersEvent event) {
        ResourceProvider provider = event.getResourceProvider();
        try {
            event.registerShader(new ShaderInstance(provider, ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"electricity"), DefaultVertexFormat.NEW_ENTITY), shaderInstance -> {
                rendertypeElectricityShader = shaderInstance;
            });
        }
        catch (IOException e) {
            MekanismWeaponry.LOGGER.warn("Failed to load shader", (Throwable)e);
        }
    }

    public static ShaderInstance getElectricityShader() {
        return Objects.requireNonNull(rendertypeElectricityShader, "Attempted to get shader before they have finished loading.");
    }

    public static void renderGui(RenderGuiEvent.Post event) {
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.getCameraType().isFirstPerson() && (player = minecraft.player) != null) {
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            scopeScale = Mth.lerp((float)(0.5f * event.getPartialTick().getGameTimeDeltaTicks()), (float)scopeScale, (float)1.0f);
            if (stack.getItem() instanceof GunItem && ((Boolean)stack.get(DataComponentRegistry.IS_SCOPING)).booleanValue()) {
                ClientSetup.renderScopeOverlay(event.getGuiGraphics(), ClientSetup.getScopeLocation(stack), scopeScale);
            } else {
                scopeScale = 0.5f;
                PostChain postEffect = Minecraft.getInstance().gameRenderer.postEffect;
                if (postEffect != null && postEffect.getName().equals("mekanism_weaponry:shaders/post/scope_blur.json")) {
                    Minecraft.getInstance().gameRenderer.shutdownEffect();
                }
            }
        }
    }

    private static ResourceLocation getScopeLocation(ItemStack stack) {
        GunItem gun = (GunItem)stack.getItem();
        ItemStack paintItem = gun.getAddon(stack, 1);
        int index = 0;
        if (paintItem.isEmpty()) {
            index = 3;
        }
        if (paintItem.is(ItemRegistry.ALIEN_PAINT_BUCKET)) {
            index = 2;
        }
        if (paintItem.is(ItemRegistry.COTTON_CANDY_PAINT_BUCKET)) {
            index = 0;
        }
        if (paintItem.is(ItemRegistry.EVA_PAINT_BUCKET)) {
            index = 0;
        }
        if (paintItem.is(ItemRegistry.BUMBLEBEE_PAINT_BUCKET)) {
            index = 0;
        }
        if (paintItem.is(ItemRegistry.CRIMSON_PAINT_BUCKET)) {
            index = 1;
        }
        return ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)String.format("textures/misc/scope_overlay_%d.png", index));
    }

    private static void renderScopeOverlay(GuiGraphics guiGraphics, ResourceLocation scopeResource, float scopeScale) {
        float f = Math.min(guiGraphics.guiWidth(), guiGraphics.guiHeight());
        float f1 = Math.min((float)guiGraphics.guiWidth() / f, (float)guiGraphics.guiHeight() / f) * scopeScale;
        int i = Mth.floor((float)(f * f1));
        int j = Mth.floor((float)(f * f1));
        int k = (guiGraphics.guiWidth() - i) / 2;
        int l = (guiGraphics.guiHeight() - j) / 2;
        RenderSystem.enableBlend();
        guiGraphics.blit(scopeResource, k, l, -90, 0.0f, 0.0f, i, j, i, j);
        RenderSystem.disableBlend();
        Minecraft.getInstance().gameRenderer.loadEffect(ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"shaders/post/scope_blur.json"));
    }

    public static void computeFov(ComputeFovModifierEvent event) {
        ItemStack stack;
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.getCameraType().isFirstPerson() && (player = minecraft.player) != null && (stack = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof GunItem && ((Boolean)stack.get(DataComponentRegistry.IS_SCOPING)).booleanValue()) {
            event.setNewFovModifier(0.2f);
        }
    }

    @SubscribeEvent
    public static void registerPaintColors(RegisterColorHandlersEvent.Item event) {
        ItemRegistry.ITEMS.getEntries().forEach(itemDeferredHolder -> {
            Object patt0$temp = itemDeferredHolder.get();
            if (patt0$temp instanceof PaintBucketItem) {
                PaintBucketItem item = (PaintBucketItem)((Object)((Object)patt0$temp));
                event.register((stack, tintIndex) -> item.getColor(tintIndex), new ItemLike[]{item});
            }
        });
    }

    static {
        RELOAD_MAPPING = Lazy.of(() -> new KeyMapping("key.mekanism_weaponry.reload", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 82, "key.categories.mekanism_weaponry"));
    }
}

