/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client.renderer;

import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.specialty.DynamicGeoItemRenderer;

public abstract class GunRenderer<T extends GunItem>
extends DynamicGeoItemRenderer<T> {
    private static ResourceLocation skinTexture;

    protected GunRenderer(GeoModel<T> model) {
        super(model);
    }

    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, T animatable, float partialTick) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && bone.getParent() != null && bone.getParent().getParent() != null && bone.getParent().getParent().getName().equals("arms")) {
            ResourceLocation skin = GunRenderer.getSkinResourceLocation(player);
            return skin;
        }
        return super.getTextureOverrideForBone(bone, animatable, partialTick);
    }

    private static ResourceLocation getSkinResourceLocation(LocalPlayer player) {
        if (skinTexture == null) {
            skinTexture = player.getSkin().texture();
        }
        return skinTexture;
    }

    protected boolean boneRenderOverride(PoseStack poseStack, GeoBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (bone.getName().equals("rightSlim") || bone.getName().equals("leftSlim")) {
            return !Minecraft.getInstance().player.getSkin().model().equals((Object)PlayerSkin.Model.SLIM);
        }
        if (bone.getName().equals("rightWide") || bone.getName().equals("leftWide")) {
            return !Minecraft.getInstance().player.getSkin().model().equals((Object)PlayerSkin.Model.WIDE);
        }
        return super.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour);
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (!this.renderPerspective.firstPerson() && bone.getName().equals("arms")) {
            return;
        }
        if (this.renderPerspective.firstPerson() && ((Boolean)this.getCurrentItemStack().get((DataComponentType)DataComponentRegistry.IS_SCOPING.get())).booleanValue()) {
            return;
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    protected int getTextureIndex() {
        if (((GunItem)this.animatable).hasAddon(this.currentItemStack, PaintBucketItem.class)) {
            return ((PaintBucketItem)((GunItem)this.animatable).getAddon(this.currentItemStack, 1).getItem()).getIndex();
        }
        return 0;
    }

    protected IntIntPair computeTextureSize(ResourceLocation texture) {
        if (texture.equals((Object)skinTexture)) {
            return IntIntPair.of((int)64, (int)64);
        }
        if (texture.getNamespace().equals("minecraft") && texture.getPath().substring(0, texture.getPath().indexOf(47)).equals("skins")) {
            return IntIntPair.of((int)64, (int)64);
        }
        return super.computeTextureSize(texture);
    }
}

