/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client.renderer;

import com.github.x3r.mekanism_weaponry.client.renderer.GunRenderer;
import com.github.x3r.mekanism_weaponry.common.item.TeslaMinigunItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3i;
import software.bernie.geckolib.model.DefaultedItemGeoModel;

public class TeslaMinigunRenderer
extends GunRenderer<TeslaMinigunItem> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"textures/entity/electricity.png");
    private final RandomSource source;
    private ElectricityNode node = null;
    private long lastNodeGenTick = 0L;

    public TeslaMinigunRenderer() {
        super(new DefaultedItemGeoModel(ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"tesla_minigun")));
        this.source = Minecraft.getInstance().player.getRandom();
    }

    public ResourceLocation getTextureLocation(TeslaMinigunItem animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)String.format("textures/item/tesla_minigun/tesla_minigun_%d.png", this.getTextureIndex()));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (transformType != ItemDisplayContext.GUI && ((TeslaMinigunItem)stack.getItem()).isShooting(stack)) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.64, -0.25);
            poseStack.scale(5.0f, 5.0f, 5.0f);
            if (transformType.firstPerson()) {
                poseStack.scale(3.0f, 3.0f, 2.0f);
            }
            this.drawElectricity(this.buildNodes(4), poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
        super.renderByItem(stack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private ElectricityNode buildNodes(int maxDepth) {
        if (this.lastNodeGenTick == Minecraft.getInstance().level.getGameTime()) {
            return this.node;
        }
        this.node = this.buildNodes(new ElectricityNode(new Vec3(0.0, 0.0, 0.0)), 0, maxDepth);
        this.lastNodeGenTick = Minecraft.getInstance().level.getGameTime();
        return this.node;
    }

    private ElectricityNode buildNodes(ElectricityNode curr, int depth, int maxDepth) {
        if (depth < maxDepth) {
            Vector3f dir = new Vector3f(0.0f, -0.01f, -4.0f);
            for (int i = 0; i < this.source.nextInt(4); ++i) {
                ElectricityNode newNode = new ElectricityNode(new Vec3((double)((float)(curr.pos.x + (double)(dir.x * 1.0f / (float)(depth + 2)) + this.source.nextGaussian() * (double)Mth.sqrt((float)((float)depth + 0.1f)) / 3.0)), (double)((float)(curr.pos.y + (double)(dir.y * 1.0f / (float)(depth + 2)) + this.source.nextGaussian() * (double)Mth.sqrt((float)((float)depth + 0.1f)) / 4.0)), (double)((float)(curr.pos.z + (double)(dir.z * 1.0f / (float)(depth + 2)) + this.source.nextGaussian() * (double)Mth.sqrt((float)((float)depth + 0.1f)) / 3.0))));
                this.buildNodes(newNode, depth + 1, maxDepth);
                curr.children.add(newNode);
            }
        }
        return curr;
    }

    private void drawElectricity(ElectricityNode node, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (node != null) {
            for (ElectricityNode electricityNode : node.children) {
                this.drawElectricity(node.pos, electricityNode.pos, poseStack, bufferSource, packedLight);
                this.drawElectricity(electricityNode, poseStack, bufferSource, packedLight);
            }
        }
    }

    private void drawElectricity(Vec3 v0, Vec3 v1, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)LOCATION));
        poseStack.pushPose();
        Vec3 corner0 = new Vec3(v0.x, v0.y, v0.z);
        Vec3 corner1 = new Vec3(v1.x, v1.y, v1.z);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, 1, 0), packedLight);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, 0, 1), packedLight);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, -1, 0), packedLight);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, 0, -1), packedLight);
        poseStack.popPose();
    }

    private void longFace(PoseStack poseStack, VertexConsumer consumer, Vec3 corner0, Vec3 corner1, Vector3i cross, int packedLight) {
        Vec3 perp = corner0.vectorTo(corner1).cross(new Vec3((double)cross.x, (double)cross.y, (double)cross.z)).normalize().scale(0.01);
        this.vertex(poseStack, consumer, corner0.subtract(perp), cross.x, cross.y, cross.z, packedLight);
        this.vertex(poseStack, consumer, corner0.add(perp), cross.x, cross.y, cross.z, packedLight);
        this.vertex(poseStack, consumer, corner1.add(perp), cross.x, cross.y, cross.z, packedLight);
        this.vertex(poseStack, consumer, corner1.subtract(perp), cross.x, cross.y, cross.z, packedLight);
    }

    private void vertex(PoseStack poseStack, VertexConsumer consumer, Vec3 vec, int normalX, int normalY, int normalZ, int packedLight) {
        consumer.addVertex(poseStack.last(), vec.toVector3f()).setColor(255, 255, 255, 255).setUv1(0, 0).setUv(16.0f, 16.0f).setLight(packedLight).setNormal(poseStack.last(), (float)normalX, (float)normalY, (float)normalZ);
    }

    public static class ElectricityNode {
        private final Set<ElectricityNode> children = new HashSet<ElectricityNode>();
        private final Vec3 pos;

        public ElectricityNode(Vec3 pos) {
            this.pos = pos;
        }
    }
}

