/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client.sound;

import com.github.x3r.mekanism_weaponry.common.item.TeslaMinigunItem;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TeslaMinigunSoundInstance
extends AbstractTickableSoundInstance {
    private final Player player;

    public TeslaMinigunSoundInstance(Player player) {
        super((SoundEvent)SoundRegistry.MINIGUN_SHOOT.get(), SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.looping = true;
        this.player = player;
    }

    public void tick() {
        TeslaMinigunItem item;
        if (this.player == null) {
            this.stop();
            return;
        }
        this.x = this.player.getX();
        this.y = this.player.getY();
        this.z = this.player.getZ();
        ItemStack stack = this.player.getItemInHand(InteractionHand.MAIN_HAND);
        Item item2 = stack.getItem();
        if (item2 instanceof TeslaMinigunItem && (item = (TeslaMinigunItem)item2).isShooting(stack)) {
            this.volume = 1.0f;
        } else {
            this.volume -= 0.1f;
            if (this.volume <= 0.1f) {
                this.stop();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TeslaMinigunSoundInstance that = (TeslaMinigunSoundInstance)((Object)obj);
        return Objects.equals(this.player, that.player);
    }

    public static void playSound(Player player) {
        TeslaMinigunSoundInstance instance;
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        if (!manager.isActive((SoundInstance)(instance = new TeslaMinigunSoundInstance(player)))) {
            manager.play((SoundInstance)instance);
        }
    }
}

