/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.datagen;

import com.github.x3r.mekanism_weaponry.common.registry.BlockRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class MWLootTableProvider
extends LootTableProvider {
    public MWLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(SoulForgeBlockSubProvider::new, LootContextParamSets.BLOCK)), registries);
    }

    private static class SoulForgeBlockSubProvider
    extends BlockLootSubProvider {
        protected SoulForgeBlockSubProvider(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected Iterable<Block> getKnownBlocks() {
            return BlockRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get()).toList();
        }

        protected void generate() {
            this.dropSelf((Block)BlockRegistry.WEAPON_WORKBENCH.get());
        }
    }
}

