/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.common.item.addon.EnergyUsageChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.FireRateChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.GunAddonItem;
import com.github.x3r.mekanism_weaponry.common.packet.ReloadGunPayload;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class GunItem
extends Item {
    private final int cooldown;
    private final int energyUsage;
    private final int reloadTime;

    protected GunItem(Item.Properties pProperties, int cooldown, int energyUsage, int reloadTime) {
        super(pProperties.stacksTo(1).setNoRepair().component((DataComponentType)DataComponentRegistry.LAST_SHOT_TICK.get(), (Object)0L).component(DataComponentRegistry.RELOADING, (Object)false).component((DataComponentType)DataComponentRegistry.ADDONS.get(), (Object)new DataComponentAddons()).component(DataComponentRegistry.IS_SHOOTING, (Object)false).component(DataComponentRegistry.IS_SCOPING, (Object)false).rarity(Rarity.UNCOMMON));
        this.cooldown = cooldown;
        this.energyUsage = energyUsage;
        this.reloadTime = reloadTime;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!this.getAddon(stack, 3).isEmpty()) {
            stack.set(DataComponentRegistry.IS_SCOPING, (Object)((Boolean)stack.get(DataComponentRegistry.IS_SCOPING) == false ? 1 : 0));
            player.getCooldowns().addCooldown(stack.getItem(), 5);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide() && !isSelected) {
            this.serverStoppedShooting(stack);
        }
    }

    public void tryStartReload(ItemStack stack, ServerPlayer player) {
        Item item = stack.getItem();
        if (item instanceof GunItem) {
            GunItem item2 = (GunItem)item;
            if (this.canReload(stack, player)) {
                item2.serverReload(stack, player);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ReloadGunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!player.getCooldowns().isOnCooldown(stack.getItem())) {
                player.serverLevel().playSound(null, player.getEyePosition().x, player.getEyePosition().y, player.getEyePosition().z, (SoundEvent)SoundRegistry.GUN_OUT_OF_AMMO.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
            }
        }
    }

    public boolean canReload(ItemStack stack, ServerPlayer serverPlayer) {
        return !serverPlayer.getCooldowns().isOnCooldown(stack.getItem());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_energy").withColor(3125974).append((Component)Component.literal((String)String.format("%d/%d FE", this.getEnergyStorage(stack).getEnergyStored(), this.getEnergyStorage(stack).getMaxEnergyStored())).withColor(0xFFFFFF)));
        if (!tooltipFlag.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_stats").append(" [SHIFT] ").withColor(0x5C5C5C));
        } else {
            this.addStatsTooltip(stack, tooltipComponents);
        }
        if (!tooltipFlag.hasControlDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_addons").append(" [CTRL] ").withColor(0x5C5C5C));
        } else {
            this.addAddonsTooltip(stack, tooltipComponents);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void addStatsTooltip(ItemStack stack, List<Component> tooltipComponents) {
        tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_stats").withColor(0x5C5C5C));
        tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_cooldown")).append(": ").withColor(9030029).append((Component)Component.literal((String)String.format("%d ticks", this.getCooldown(stack))).withColor(0xFFFFFF)));
        tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_energy_usage")).append(": ").withColor(9030029).append((Component)Component.literal((String)String.format("%d / shot", this.getEnergyUsage(stack))).withColor(0xFFFFFF)));
        tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_reload_time")).append(": ").withColor(9030029).append((Component)Component.literal((String)String.format("%d ticks", this.reloadTime)).withColor(0xFFFFFF)));
    }

    public void addAddonsTooltip(ItemStack stack, List<Component> tooltipComponents) {
        tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_addons").withColor(0x5C5C5C));
        DataComponentAddons addons = (DataComponentAddons)stack.get((DataComponentType)DataComponentRegistry.ADDONS.get());
        if (Arrays.stream(addons.getAddons()).allMatch(s -> s.equals(ItemStack.EMPTY))) {
            tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_no_addons"));
        } else {
            for (ItemStack addon : addons.getAddons()) {
                if (addon.equals(ItemStack.EMPTY)) continue;
                tooltipComponents.add((Component)Component.literal((String)" ").append(addon.getHoverName()));
            }
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.getItem().equals(newStack.getItem());
    }

    public boolean isReady(ItemStack stack, ServerPlayer player, Level level) {
        long tick = level.getGameTime();
        return !player.getCooldowns().isOnCooldown(stack.getItem()) && this.isOffCooldown(stack, tick) && this.hasSufficientEnergy(stack);
    }

    public int getCooldown(ItemStack stack) {
        return (int)Math.max(0.0f, (float)this.cooldown - this.getAddonMultiplier(stack, FireRateChipItem.class));
    }

    public int getEnergyUsage(ItemStack stack) {
        return (int)Math.max(0.0f, (float)this.energyUsage - 10.0f * this.getAddonMultiplier(stack, EnergyUsageChipItem.class));
    }

    public int getReloadTime(ItemStack stack) {
        return this.reloadTime;
    }

    public long getLastShotTick(ItemStack stack) {
        return (Long)stack.get((DataComponentType)DataComponentRegistry.LAST_SHOT_TICK.get());
    }

    public void setLastShotTick(ItemStack stack, long tick) {
        stack.set((DataComponentType)DataComponentRegistry.LAST_SHOT_TICK.get(), (Object)tick);
    }

    public boolean isOffCooldown(ItemStack stack, long tick) {
        return tick - this.getLastShotTick(stack) >= (long)this.getCooldown(stack);
    }

    public IEnergyStorage getEnergyStorage(ItemStack stack) {
        return (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
    }

    public boolean hasSufficientEnergy(ItemStack stack) {
        return this.getEnergyStorage(stack).getEnergyStored() >= this.energyUsage;
    }

    public ItemStack getAddon(ItemStack stack, int index) {
        DataComponentAddons addons = (DataComponentAddons)stack.get((DataComponentType)DataComponentRegistry.ADDONS.get());
        return addons.getAddon(index);
    }

    public boolean hasAddon(ItemStack stack, Class<? extends GunAddonItem> addon) {
        DataComponentAddons addons = (DataComponentAddons)stack.get((DataComponentType)DataComponentRegistry.ADDONS.get());
        for (int i = 0; i < 5; ++i) {
            if (!addon.isInstance(addons.getAddon(i).getItem())) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getAddonsOfType(ItemStack stack, Class<? extends GunAddonItem> addonClass) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack addonStack = this.getAddon(stack, i);
            if (!addonClass.isInstance(addonStack.getItem())) continue;
            list.add(addonStack);
        }
        return list;
    }

    public float getAddonMultiplier(ItemStack stack, Class<? extends GunAddonItem> addonClass) {
        float count = 0.0f;
        DataComponentAddons addons = (DataComponentAddons)stack.get((DataComponentType)DataComponentRegistry.ADDONS.get());
        for (int i = 0; i < 5; ++i) {
            if (!addonClass.isInstance(addons.getAddon(i).getItem())) continue;
            count += ((GunAddonItem)addons.getAddon(i).getItem()).mul();
        }
        return count;
    }

    public void setAddon(ItemStack stack, ItemStack chipStack, int index) {
        DataComponentAddons addons = (DataComponentAddons)stack.get((DataComponentType)DataComponentRegistry.ADDONS.get());
        ItemStack[] addonArr = new ItemStack[5];
        for (int i = 0; i < addonArr.length; ++i) {
            addonArr[i] = addons.getAddon(i);
        }
        addonArr[index] = chipStack;
        stack.set((DataComponentType)DataComponentRegistry.ADDONS.get(), (Object)new DataComponentAddons(addonArr[0], addonArr[1], addonArr[2], addonArr[3], addonArr[4]));
    }

    public boolean isShooting(ItemStack stack) {
        return (Boolean)stack.get(DataComponentRegistry.IS_SHOOTING);
    }

    public abstract void serverShoot(ItemStack var1, ServerPlayer var2);

    public abstract void clientShoot(ItemStack var1, Player var2);

    public abstract void serverReload(ItemStack var1, ServerPlayer var2);

    public abstract void clientReload(ItemStack var1, Player var2);

    public void serverStoppedShooting(ItemStack stack) {
        stack.set(DataComponentRegistry.IS_SHOOTING, (Object)false);
    }

    public abstract boolean canInstallAddon(ItemStack var1, ItemStack var2);

    public record DataComponentAddons(ItemStack chip1, ItemStack paint, ItemStack chip2, ItemStack scope, ItemStack chip3) {
        public DataComponentAddons() {
            this(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
        }

        public ItemStack[] getAddons() {
            return new ItemStack[]{this.chip1, this.paint, this.chip2, this.scope, this.chip3};
        }

        public ItemStack getAddon(int index) {
            switch (index) {
                case 0: {
                    return this.chip1;
                }
                case 1: {
                    return this.paint;
                }
                case 2: {
                    return this.chip2;
                }
                case 3: {
                    return this.scope;
                }
                case 4: {
                    return this.chip3;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

