/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.MekanismWeaponryConfig;
import com.github.x3r.mekanism_weaponry.client.renderer.TeslaMinigunRenderer;
import com.github.x3r.mekanism_weaponry.client.sound.TeslaMinigunSoundInstance;
import com.github.x3r.mekanism_weaponry.common.item.HeatGunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.EnergyUsageChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.FireRateChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.packet.ActivateGunPayload;
import com.github.x3r.mekanism_weaponry.common.registry.DamageTypeRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import com.github.x3r.mekanism_weaponry.common.scheduler.Scheduler;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TeslaMinigunItem
extends HeatGunItem
implements GeoItem {
    private static final RawAnimation IDLE = RawAnimation.begin().then("idle", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation RELOAD = RawAnimation.begin().then("overheat", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHOOT = RawAnimation.begin().then("fire", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TeslaMinigunItem(Item.Properties pProperties) {
        super(pProperties, MekanismWeaponryConfig.CONFIG.getTeslaMinigunCooldown(), MekanismWeaponryConfig.CONFIG.getTeslaMinigunEnergyUsage(), MekanismWeaponryConfig.CONFIG.getTeslaMinigunReloadTime(), MekanismWeaponryConfig.CONFIG.getTeslaMinigunHeatPerShot());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public void serverShoot(ItemStack stack, ServerPlayer player) {
        Level level = player.level();
        Vec3 pos = player.getEyePosition().add(player.getLookAngle().normalize().scale(0.1));
        if (this.isReady(stack, player, level)) {
            stack.set(DataComponentRegistry.IS_SHOOTING, (Object)true);
            this.setLastShotTick(stack, level.getGameTime());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ActivateGunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.getEnergyStorage(stack).extractEnergy(this.getEnergyUsage(stack), false);
            this.setHeat(stack, this.getHeat(stack) + this.getHeatPerShot(stack));
            HashSet entitiesToHurt = new HashSet();
            for (int i = 0; i <= 3; ++i) {
                Vec3 hurtVolumeCenter = player.position().add(player.getLookAngle().normalize().scale((double)(2 * i)));
                AABB hurtBox = AABB.ofSize((Vec3)hurtVolumeCenter, (double)2.0, (double)3.0, (double)2.0);
                entitiesToHurt.addAll(level.getEntities((Entity)player, hurtBox));
            }
            entitiesToHurt.forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    entity.hurt(new DamageTypeRegistry(player.level().registryAccess()).electricity((Entity)player), (float)MekanismWeaponryConfig.CONFIG.getTeslaMinigunDamage());
                }
            });
        } else {
            if (!this.hasSufficientEnergy(stack)) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.GUN_OUT_OF_ENERGY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (this.isOverheated(stack)) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.REDSTONE_TORCH_BURNOUT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            stack.set(DataComponentRegistry.IS_SHOOTING, (Object)false);
        }
    }

    @Override
    public void clientShoot(ItemStack stack, Player player) {
        TeslaMinigunSoundInstance.playSound(player);
    }

    @Override
    public void serverReload(ItemStack stack, ServerPlayer player) {
        player.getCooldowns().addCooldown(stack.getItem(), this.getReloadTime(stack));
        int i = 0;
        while ((float)i < this.getHeat(stack)) {
            Scheduler.schedule(() -> {
                if (player.getInventory().contains(stack)) {
                    this.setHeat(stack, Math.max(0.0f, this.getHeat(stack) - 2.0f));
                }
            }, 40 + i);
            ++i;
        }
        Scheduler.schedule(() -> {
            if (player.getInventory().contains(stack)) {
                player.serverLevel().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }, 40);
    }

    @Override
    public void clientReload(ItemStack stack, Player player) {
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "reload");
    }

    @Override
    public boolean canInstallAddon(ItemStack gunStack, ItemStack addonStack) {
        if (addonStack.getItem().getClass().equals(EnergyUsageChipItem.class)) {
            return true;
        }
        if (addonStack.getItem().getClass().equals(FireRateChipItem.class)) {
            return true;
        }
        if (addonStack.getItem().getClass().equals(PaintBucketItem.class)) {
            return true;
        }
        return super.canInstallAddon(gunStack, addonStack);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private TeslaMinigunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new TeslaMinigunRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 1, state -> {
            if (!state.getController().isPlayingTriggeredAnimation()) {
                state.setAnimation(IDLE);
            }
            if (((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).firstPerson()) {
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }).receiveTriggeredAnimations().triggerableAnim("reload", RELOAD).triggerableAnim("shoot", SHOOT));
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

