/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.menu;

import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.GunAddonItem;
import com.github.x3r.mekanism_weaponry.common.registry.BlockRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.MenuTypeRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class WeaponWorkbenchMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Container container;

    public WeaponWorkbenchMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public WeaponWorkbenchMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)MenuTypeRegistry.WEAPON_WORKBENCH.get(), containerId);
        int i;
        this.access = access;
        this.container = this.createContainer();
        this.addSlot(new GunSlot(this.container, 0, 8, 16));
        this.addSlot(new AddonSlot(this.container, 1, 152, 16, GunAddonItem.AddonType.CHIP));
        this.addSlot(new AddonSlot(this.container, 2, 8, 35, GunAddonItem.AddonType.PAINT));
        this.addSlot(new AddonSlot(this.container, 3, 152, 35, GunAddonItem.AddonType.CHIP));
        this.addSlot(new AddonSlot(this.container, 4, 8, 54, GunAddonItem.AddonType.SCOPE));
        this.addSlot(new AddonSlot(this.container, 5, 152, 54, GunAddonItem.AddonType.CHIP));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void onItemSet(int index, ItemStack itemStack) {
        if (index == 0) {
            Item item = itemStack.getItem();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                for (int i = 1; i < 6; ++i) {
                    this.container.setItem(i, gunItem.getAddon(itemStack, i - 1));
                }
            } else {
                for (int i = 1; i < 6; ++i) {
                    this.container.setItem(i, ItemStack.EMPTY);
                }
            }
        } else {
            ItemStack gunStack = this.container.getItem(0);
            Item item = gunStack.getItem();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                gunItem.setAddon(gunStack, itemStack, index - 1);
            }
        }
    }

    private Container createContainer() {
        return new SimpleContainer(6){

            public void setChanged() {
                super.setChanged();
                WeaponWorkbenchMenu.this.slotsChanged((Container)this);
            }

            public void setItem(int index, ItemStack stack) {
                super.setItem(index, stack);
                WeaponWorkbenchMenu.this.onItemSet(index, stack);
            }
        };
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((p_39796_, p_39797_) -> this.clearContainer(player, this.container));
    }

    protected void clearContainer(Player player, Container container) {
        ServerPlayer serverPlayer;
        if (!player.isAlive() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected()) {
            player.drop(container.removeItemNoUpdate(0), false);
        } else {
            Inventory inventory = player.getInventory();
            if (inventory.player instanceof ServerPlayer) {
                inventory.placeItemBackInInventory(container.removeItemNoUpdate(0));
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 6 ? !this.moveItemStackTo(itemstack1, 6, 42, true) : !this.moveItemStackTo(itemstack1, 0, 6, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return WeaponWorkbenchMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.WEAPON_WORKBENCH.get()));
    }

    private static class GunSlot
    extends Slot {
        public GunSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.getItem() instanceof GunItem;
        }
    }

    private static class AddonSlot
    extends Slot {
        private final GunAddonItem.AddonType addonType;

        public AddonSlot(Container container, int slot, int x, int y, GunAddonItem.AddonType addonType) {
            super(container, slot, x, y);
            this.addonType = addonType;
        }

        public boolean mayPlace(ItemStack stack) {
            GunItem gunItem;
            GunAddonItem gunAddonItem;
            Item item = stack.getItem();
            return item instanceof GunAddonItem && (gunAddonItem = (GunAddonItem)item).getAddonType().equals((Object)this.addonType) && !this.container.getItem(0).isEmpty() && (item = this.container.getItem(0).getItem()) instanceof GunItem && (gunItem = (GunItem)item).canInstallAddon(this.container.getItem(0), stack);
        }
    }
}

