/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;

public class DamageTypeRegistry {
    private final Registry<DamageType> damageTypes;
    private final ResourceKey<DamageType> plasma = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"plasma"));
    private final ResourceKey<DamageType> rod = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"rod"));
    private final ResourceKey<DamageType> electricity = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"electricity"));

    public DamageTypeRegistry(RegistryAccess registryAccess) {
        this.damageTypes = registryAccess.registryOrThrow(Registries.DAMAGE_TYPE);
    }

    public DamageSource plasma(Entity entity) {
        return this.source(this.plasma, entity);
    }

    public DamageSource rod(Entity entity) {
        return this.source(this.rod, entity);
    }

    public DamageSource electricity(Entity entity) {
        return this.source(this.electricity, entity);
    }

    private DamageSource source(ResourceKey<DamageType> key) {
        return new DamageSource((Holder)this.damageTypes.getHolderOrThrow(key));
    }

    private DamageSource source(ResourceKey<DamageType> key, Entity entity) {
        return new DamageSource((Holder)this.damageTypes.getHolderOrThrow(key), entity, entity, null);
    }
}

