/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.client.gui.components.toasts;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.skill.Skill;

@OnlyIn(value=Dist.CLIENT)
public class SkillTreeNodeToast
implements Toast {
    private final Holder<Skill> skill;

    public SkillTreeNodeToast(Holder<Skill> skill) {
        this.skill = skill;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        if (this.skill == null || this.skill.value() == null) {
            return Toast.Visibility.HIDE;
        }
        guiGraphics.blitSprite(TutorialToast.BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        guiGraphics.blit(((Skill)this.skill.value()).getSkillTexture(), 5, 3, 26, 26, 0.0f, 0.0f, 32, 32, 32, 32);
        MutableComponent line1 = Component.translatable((String)"chat.epicskills.unlock_notification");
        MutableComponent line2 = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)((Skill)this.skill.value()).getTranslationKey())).withStyle(ChatFormatting.GOLD);
        guiGraphics.drawString(toastComponent.getMinecraft().font, (Component)line1, 36, 6, -1);
        guiGraphics.drawString(toastComponent.getMinecraft().font, (Component)line2, 36, 17, -1);
        return (double)timeSinceLastVisible >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

