/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.network;

import com.yesman.epicskills.client.gui.screen.SkillTreeScreen;
import com.yesman.epicskills.network.client.ClientBoundReloadSkillTree;
import com.yesman.epicskills.network.client.ClientBoundSetAbilityPoints;
import com.yesman.epicskills.network.client.ClientBoundSetTreeState;
import com.yesman.epicskills.network.client.ClientBoundSyncTreeState;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public interface EpicSkillsClientBoundPayloadHandler {
    public static void handleReloadSkillTree(ClientBoundReloadSkillTree data, IPayloadContext context) {
        context.player().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> skillTreeProgression.reload(data.readOldData()));
    }

    public static void handleSetAbilityPoints(ClientBoundSetAbilityPoints data, IPayloadContext context) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof SkillTreeScreen) {
            SkillTreeScreen skillTreeScreen = (SkillTreeScreen)screen;
            skillTreeScreen.onSyncPacketArrived(data);
        }
        context.player().getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoint -> {
            abilityPoint.setAbilityPoints(data.abilityPoint());
            abilityPoint.setRequiredExp(data.requiredExp());
            context.player().giveExperiencePoints(-abilityPoint.getRequiredExp());
        });
    }

    public static void handleSyncTreeState(ClientBoundSyncTreeState data, IPayloadContext context) {
        context.player().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> skillTreeProgression.deserializeFrom(data.compound()));
    }

    public static void handleUnlockNode(ClientBoundUnlockNode data, IPayloadContext context) {
        context.player().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skilltreeProgression -> skilltreeProgression.processSyncPacket(data));
    }

    public static void handleUnlockTree(ClientBoundSetTreeState data, IPayloadContext context) {
        context.player().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skilltreeProgression -> skilltreeProgression.processSyncPacket(data));
    }
}

