/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.yesman.epicskills.neoforge.attachment.AbilityPoints;
import com.yesman.epicskills.neoforge.attachment.SkillTreeProgression;
import com.yesman.epicskills.network.client.ClientBoundReloadSkillTree;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import com.yesman.epicskills.skilltree.SkillTree;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.utils.MutableBoolean;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.server.commands.arguments.SkillArgument;
import yesman.epicfight.skill.Skill;

public class PlayerSkillTreeCommand {
    private static final SimpleCommandExceptionType EXCEPTION_NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicskills.failed.no_players"));
    private static final SimpleCommandExceptionType EXCEPTION_UNABLE_TO_UNLOCK = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicskills.skilltree_progression.unlock.failed"));
    private static final SimpleCommandExceptionType EXCEPTION_UNABLE_TO_LOCK = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicskills.skilltree_progression.lock.failed"));
    private static final SimpleCommandExceptionType EXCEPTION_UNABLE_TO_LOCK_TREE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicskills.skilltree_progression.lock_tree.failed"));
    private static final SimpleCommandExceptionType ERROR_INVALID_PLAYER_DATA = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicskills.skilltree_progression.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext pContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skilltree").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), null, null, Action.RESET, true, false)))).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, (Collection<ServerPlayer>)ImmutableList.of((Object)((CommandSourceStack)command.getSource()).getPlayerOrException()), null, null, Action.RESET, true, false)))).then(Commands.literal((String)"unlock").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"skilltree", (ArgumentType)ResourceArgument.resource((CommandBuildContext)pContext, SkillTree.SKILL_TREE_REGISTRY_KEY)).then(((RequiredArgumentBuilder)Commands.argument((String)"skill", (ArgumentType)SkillArgument.skill()).then(Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), (Holder<Skill>)SkillArgument.getSkill((CommandContext)command, (String)"skill"), Action.UNLOCK, BoolArgumentType.getBool((CommandContext)command, (String)"force"), false)))).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), (Holder<Skill>)SkillArgument.getSkill((CommandContext)command, (String)"skill"), Action.UNLOCK, false, false)))).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), null, Action.UNLOCK_TREE, false, false)))))).then(Commands.literal((String)"lock").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"skilltree", (ArgumentType)ResourceArgument.resource((CommandBuildContext)pContext, SkillTree.SKILL_TREE_REGISTRY_KEY)).then(((RequiredArgumentBuilder)Commands.argument((String)"skill", (ArgumentType)SkillArgument.skill()).then(((RequiredArgumentBuilder)Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"unequip", (ArgumentType)BoolArgumentType.bool()).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), (Holder<Skill>)SkillArgument.getSkill((CommandContext)command, (String)"skill"), Action.LOCK, BoolArgumentType.getBool((CommandContext)command, (String)"force"), BoolArgumentType.getBool((CommandContext)command, (String)"unequip"))))).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), (Holder<Skill>)SkillArgument.getSkill((CommandContext)command, (String)"skill"), Action.LOCK, BoolArgumentType.getBool((CommandContext)command, (String)"force"), false)))).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), (Holder<Skill>)SkillArgument.getSkill((CommandContext)command, (String)"skill"), Action.LOCK, false, false)))).then(((RequiredArgumentBuilder)Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"unequip", (ArgumentType)BoolArgumentType.bool()).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), null, Action.LOCK_TREE, BoolArgumentType.getBool((CommandContext)command, (String)"force"), BoolArgumentType.getBool((CommandContext)command, (String)"unequip"))))).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), null, Action.LOCK_TREE, BoolArgumentType.getBool((CommandContext)command, (String)"force"), false)))).executes(command -> PlayerSkillTreeCommand.proccessSkillTreeCommand((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), (Holder.Reference<SkillTree>)ResourceArgument.getResource((CommandContext)command, (String)"skilltree", SkillTree.SKILL_TREE_REGISTRY_KEY), null, Action.LOCK_TREE, false, false))))));
    }

    private static int proccessSkillTreeCommand(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> players, @Nullable Holder.Reference<SkillTree> skillTree, @Nullable Holder<Skill> skill, Action action, boolean force, boolean unequip) throws CommandSyntaxException {
        int done = 0;
        if (players.isEmpty()) {
            throw EXCEPTION_NO_PLAYERS_FOUND.create();
        }
        switch (action.ordinal()) {
            case 0: {
                for (ServerPlayer player : players) {
                    if (!PlayerSkillTreeCommand.resetTree(player)) continue;
                    ++done;
                }
                break;
            }
            case 3: {
                for (ServerPlayer player : players) {
                    if (!PlayerSkillTreeCommand.unlockTreeNode(player, skillTree, skill, force)) continue;
                    ++done;
                }
                break;
            }
            case 4: {
                for (ServerPlayer player : players) {
                    if (!PlayerSkillTreeCommand.lockTreeNode(player, skillTree, skill, force, unequip)) continue;
                    ++done;
                }
                break;
            }
            case 1: {
                for (ServerPlayer player : players) {
                    if (!PlayerSkillTreeCommand.unlockTree(player, skillTree)) continue;
                    ++done;
                }
                break;
            }
            case 2: {
                for (ServerPlayer player : players) {
                    if (!PlayerSkillTreeCommand.lockTree(player, skillTree, force, unequip)) continue;
                    ++done;
                }
                break;
            }
        }
        if (done == 0) {
            switch (action.ordinal()) {
                case 0: {
                    throw ERROR_INVALID_PLAYER_DATA.create();
                }
                case 3: {
                    throw EXCEPTION_UNABLE_TO_UNLOCK.create();
                }
                case 4: {
                    throw EXCEPTION_UNABLE_TO_LOCK.create();
                }
                case 1: {
                    throw ERROR_INVALID_PLAYER_DATA.create();
                }
                case 2: {
                    throw EXCEPTION_UNABLE_TO_LOCK_TREE.create();
                }
            }
        } else if (done == 1) {
            ((CommandSourceStack)command.getSource()).sendSuccess(PlayerSkillTreeCommand.wrap(Component.translatable((String)("commands.epicskills.skilltree_progression." + action.id + ".success.single"), (Object[])action.singleTranslatableKeyParameters.parameters(command, players, skillTree, skill, done))), true);
        } else {
            for (ServerPlayer serverplayer : players) {
                if (!((CommandSourceStack)command.getSource()).getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) continue;
                serverplayer.sendSystemMessage((Component)Component.translatable((String)("commands.epicskills.skilltree_progression." + action.id + ".success.other"), (Object[])action.multipleTranslatableKeyParameters.parameters(command, players, skillTree, skill, done)));
            }
            ((CommandSourceStack)command.getSource()).sendSuccess(PlayerSkillTreeCommand.wrap(Component.translatable((String)("commands.epicskills.skilltree_progression." + action.id + ".success.other"), (Object[])action.multipleTranslatableKeyParameters.parameters(command, players, skillTree, skill, done))), true);
        }
        return done;
    }

    private static boolean resetTree(ServerPlayer player) {
        player.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
            skillTreeProgression.reload(false);
            EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundReloadSkillTree(false), (ServerPlayer)player, (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        return player.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).isPresent();
    }

    private static boolean unlockTreeNode(ServerPlayer player, Holder.Reference<SkillTree> skillTree, Holder<Skill> skill, boolean force) {
        MutableBoolean succeess = new MutableBoolean(false);
        player.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoints -> {
            if (force || skillTreeProgression.canUnlockNode(skillTree, (Skill)skill.value(), (AbilityPoints)abilityPoints, false)) {
                skillTreeProgression.unlockNode(skillTree, (Skill)skill.value());
                EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundUnlockNode((ResourceKey<SkillTree>)skillTree.key(), skill, SkillTreeProgression.NodeState.UNLOCKED, false, false, false, false), (ServerPlayer)player, (CustomPacketPayload[])new CustomPacketPayload[0]);
                succeess.set(true);
            }
        }));
        return succeess.value();
    }

    private static boolean lockTreeNode(ServerPlayer player, Holder.Reference<SkillTree> skillTree, Holder<Skill> skill, boolean force, boolean unequip) {
        MutableBoolean succeess = new MutableBoolean(false);
        player.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
            if (force || skillTreeProgression.canLockNode(skillTree, (Skill)skill.value())) {
                skillTreeProgression.lockNode(skillTree, (Skill)skill.value(), unequip);
                EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundUnlockNode((ResourceKey<SkillTree>)skillTree.key(), skill, SkillTreeProgression.NodeState.LOCKED, false, unequip, false, false), (ServerPlayer)player, (CustomPacketPayload[])new CustomPacketPayload[0]);
                succeess.set(true);
            }
        });
        return succeess.value();
    }

    private static boolean unlockTree(ServerPlayer player, Holder.Reference<SkillTree> skillTree) {
        MutableBoolean succeess = new MutableBoolean(false);
        player.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
            skillTreeProgression.unlockTree(skillTree);
            succeess.set(true);
        });
        return succeess.value();
    }

    private static boolean lockTree(ServerPlayer player, Holder.Reference<SkillTree> skillTree, boolean force, boolean unequip) {
        MutableBoolean succeess = new MutableBoolean(false);
        player.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
            if (force || skillTreeProgression.canLockTree(skillTree)) {
                skillTreeProgression.lockTree(skillTree, unequip);
                succeess.set(true);
            }
        });
        return succeess.value();
    }

    private static <T> Supplier<T> wrap(T value) {
        return () -> value;
    }

    public static enum Action {
        RESET("reset", (command, players, skillTree, skill, successCount) -> new Object[]{((ServerPlayer)players.iterator().next()).getDisplayName()}, (command, players, skillTree, skill, successCount) -> new Object[]{String.valueOf(successCount)}),
        UNLOCK_TREE("unlock_tree", (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), ((ServerPlayer)players.iterator().next()).getDisplayName()}, (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), String.valueOf(successCount)}),
        LOCK_TREE("lock_tree", (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), ((ServerPlayer)players.iterator().next()).getDisplayName()}, (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), String.valueOf(successCount)}),
        UNLOCK("unlock", (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)((Skill)skill.value()).getTranslationKey()).getString(), Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), ((ServerPlayer)players.iterator().next()).getDisplayName()}, (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)((Skill)skill.value()).getTranslationKey()).getString(), Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), String.valueOf(successCount)}),
        LOCK("lock", (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)((Skill)skill.value()).getTranslationKey()).getString(), Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), ((ServerPlayer)players.iterator().next()).getDisplayName()}, (command, players, skillTree, skill, successCount) -> new Object[]{Component.translatable((String)((Skill)skill.value()).getTranslationKey()).getString(), Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key())).getString(), String.valueOf(successCount)});

        TranslatableKeyParameters singleTranslatableKeyParameters;
        TranslatableKeyParameters multipleTranslatableKeyParameters;
        String id;

        private Action(String id, TranslatableKeyParameters singleTranslatableKeyParameters, TranslatableKeyParameters multipleTranslatableKeyParameters) {
            this.id = id;
            this.singleTranslatableKeyParameters = singleTranslatableKeyParameters;
            this.multipleTranslatableKeyParameters = multipleTranslatableKeyParameters;
        }
    }

    @FunctionalInterface
    public static interface TranslatableKeyParameters {
        public Object[] parameters(CommandContext<CommandSourceStack> var1, Collection<ServerPlayer> var2, @Nullable Holder.Reference<SkillTree> var3, @Nullable Holder<Skill> var4, int var5);
    }
}

