/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.cog_crank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.content.blocks.kinetics.cog_crank.CogCrankBlock;
import dev.lopyluna.dndesires.register.DesiresBlocks;
import dev.lopyluna.dndesires.register.client.DesiresPartialModels;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CogCrankBE
extends GeneratingKineticBlockEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public CogCrankBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLarge() {
        Block block = this.getBlockState().getBlock();
        if (!(block instanceof CogCrankBlock)) return false;
        CogCrankBlock block2 = (CogCrankBlock)block;
        if (!block2.isLarge) return false;
        return true;
    }

    public BlockEntry<CogCrankBlock> getBlockEntry() {
        return this.isLarge() ? DesiresBlocks.LARGE_COG_CRANK : DesiresBlocks.COG_CRANK;
    }

    public Direction facing(Direction.Axis axis) {
        return Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
    }

    public void turn(boolean back) {
        assert (this.level != null);
        boolean update = this.getGeneratedSpeed() == 0.0f || back != this.backwards;
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.level.isClientSide) {
            this.updateGeneratedRotation();
        }
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    public float getGeneratedSpeed() {
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof CogCrankBlock) {
            CogCrankBlock crank = (CogCrankBlock)block;
            return CogCrankBE.convertToDirection((float)((this.inUse == 0 ? 0 : (this.clockwise() ? -1 : 1)) * crank.getRotationSpeed()), (Direction)this.facing((Direction.Axis)state.getValue((Property)CogCrankBlock.AXIS)));
        }
        return 0.0f;
    }

    protected boolean clockwise() {
        return this.backwards;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("InUse", this.inUse);
        compound.putBoolean("Backwards", this.backwards);
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.inUse = compound.getInt("InUse");
        this.backwards = compound.getBoolean("Backwards");
        super.read(compound, registries, clientPacket);
    }

    public void tick() {
        super.tick();
        assert (this.level != null);
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0 && --this.inUse == 0 && !this.level.isClientSide) {
            this.sequenceContext = null;
            this.updateGeneratedRotation();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public SuperByteBuffer getRenderedHandle() {
        BlockState blockState = this.getBlockState();
        Direction.Axis axis = blockState.getOptionalValue((Property)CogCrankBlock.AXIS).orElse(Direction.Axis.Y);
        return CachedBuffers.partialFacing((PartialModel)DesiresPartialModels.COG_CRANK_HANDLE, (BlockState)blockState, (Direction)this.facing(axis));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderCog() {
        return true;
    }

    protected Block getStressConfigKey() {
        BlockEntry<CogCrankBlock> entry = this.getBlockEntry();
        return entry.has(this.getBlockState()) ? (Block)entry.get() : (Block)AllBlocks.COPPER_VALVE_HANDLE.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.inUse > 0 && AnimationTickHolder.getTicks() % 10 == 0) {
            BlockEntry<CogCrankBlock> entry = this.getBlockEntry();
            if (!entry.has(this.getBlockState())) {
                return;
            }
            AllSoundEvents.CRANKING.playAt(this.level, (Vec3i)this.worldPosition, (float)this.inUse / 2.5f, 0.65f + (float)(10 - this.inUse) / 10.0f, true);
        }
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return state.getBlock() instanceof ICogWheel || block instanceof ICogWheel;
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (!ICogWheel.isLargeCog((BlockState)state)) {
            return super.addPropagationLocations(block, state, neighbours);
        }
        for (BlockPos offset : BlockPos.betweenClosed((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1)) {
            if (offset.distSqr((Vec3i)BlockPos.ZERO) != 2.0) continue;
            neighbours.add(this.worldPosition.offset((Vec3i)offset));
        }
        return neighbours;
    }
}

