/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.multimeter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.content.blocks.kinetics.multimeter.MultiMeterBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.multimeter.MultiMeterBlock;
import dev.lopyluna.dndesires.register.client.DesiresPartialModels;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MultiMeterRenderer
extends ShaftRenderer<MultiMeterBE> {
    public MultiMeterRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(MultiMeterBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        BlockState state = be.getBlockState();
        PartialModel model = DesiresPartialModels.MULTIMETER_HEAD;
        SuperByteBuffer headBuffer = CachedBuffers.partial((PartialModel)model, (BlockState)state);
        SuperByteBuffer dialBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.GAUGE_DIAL, (BlockState)state);
        float dialPivot = 0.359375f;
        float progress = Mth.lerp((float)partialTicks, (float)be.prevDialState, (float)be.dialState);
        for (Direction facing : Iterate.directions) {
            MultiMeterBlock block;
            Block block2 = state.getBlock();
            if (block2 instanceof MultiMeterBlock && (block = (MultiMeterBlock)block2).shouldntRenderHeadOnFace(level, pos, state, facing)) continue;
            VertexConsumer vb = buffer.getBuffer(RenderType.solid());
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.rotateBufferTowards(dialBuffer, facing).translate(0.0f, dialPivot, dialPivot)).rotate((float)(1.5707963267948966 * (double)(-progress)), Direction.EAST)).translate(0.0f, -dialPivot, -dialPivot)).light(light).renderInto(ms, vb);
            this.rotateBufferTowards(headBuffer, facing).light(light).renderInto(ms, vb);
        }
    }

    protected SuperByteBuffer rotateBufferTowards(SuperByteBuffer buffer, Direction target) {
        return (SuperByteBuffer)buffer.rotateCentered((float)((double)((-target.toYRot() - 90.0f) / 180.0f) * Math.PI), Direction.UP);
    }
}

