/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.StirlingEngineBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.StirlingEngineBlock;
import dev.lopyluna.dndesires.register.client.DesiresPartialModels;
import java.util.Objects;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StirlingEngineVisual
extends AbstractBlockEntityVisual<StirlingEngineBE>
implements SimpleDynamicVisual {
    protected TransformedInstance piston;
    protected TransformedInstance linkage;
    private Float lastAngle = Float.valueOf(Float.NaN);
    protected TransformedInstance frame;

    public StirlingEngineVisual(VisualizationContext ctx, StirlingEngineBE blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        this.piston = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)DesiresPartialModels.ENGINE_PISTON)).createInstance();
        this.linkage = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)DesiresPartialModels.ENGINE_LINKAGE)).createInstance();
        this.animate();
        Direction facing = (Direction)this.blockState.getValue((Property)StirlingEngineBlock.FACING);
        float angle = AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing));
        this.frame = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)DesiresPartialModels.FRAME)).createInstance();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.frame.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).nudge(this.pos.hashCode())).rotateCentered(angle, Direction.UP)).translate(0.0f, 0.0f, -1.0f);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.piston);
        consumer.accept((Instance)this.linkage);
        consumer.accept((Instance)this.frame);
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.piston, this.linkage, this.frame});
    }

    protected void _delete() {
        this.piston.delete();
        this.linkage.delete();
        this.frame.delete();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate();
    }

    private void animate() {
        Float angle = ((StirlingEngineBE)this.blockEntity).getTargetAngle();
        if (Objects.equals(angle, this.lastAngle)) {
            return;
        }
        this.lastAngle = angle;
        if (angle == null) {
            this.piston.setVisible(false);
            this.linkage.setVisible(false);
            return;
        }
        this.piston.setVisible(true);
        this.linkage.setVisible(true);
        Direction facing = StirlingEngineBlock.getFacing(this.blockState);
        Direction.Axis facingAxis = facing.getAxis();
        boolean roll90 = !facingAxis.isHorizontal();
        float sine = Mth.sin((float)angle.floatValue());
        float sine2 = Mth.sin((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        this.transformed(this.piston, facing, roll90).translate(0.0f, piston, 0.0f).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.transformed(this.linkage, facing, roll90).center()).translate(0.0f, 1.0f, 0.0f).uncenter()).translate(0.0f, piston, 0.0f).translate(0.0f, 0.25f, 0.5f).rotateXDegrees(sine2 * 23.0f)).translate(0.0f, -0.25f, -0.5f).setChanged();
    }

    protected TransformedInstance transformed(TransformedInstance modelData, Direction facing, boolean roll90) {
        return (TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)modelData.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing) + 90.0f)).rotateYDegrees(roll90 ? -90.0f : 0.0f)).uncenter();
    }
}

