/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.logistics.roll_table;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.lopyluna.dndesires.content.blocks.logistics.roll_table.RollTableBE;
import java.util.Random;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RollTableRenderer
extends SmartBlockEntityRenderer<RollTableBE> {
    public RollTableRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(RollTableBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        this.renderItem(be, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(RollTableBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean packages;
        boolean alongX;
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        Vec3 itemPosition = VecHelper.getCenterOf((Vec3i)be.getBlockPos());
        Direction insertedFrom = transported.insertedFrom;
        if (!insertedFrom.getAxis().isHorizontal()) {
            return;
        }
        ms.pushPose();
        ms.translate(0.5f, 0.9375f, 0.5f);
        msr.nudge(0);
        float offset = Mth.lerp((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
        float sideOffset = Mth.lerp((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
        Vec3 offsetVec = Vec3.atLowerCornerOf((Vec3i)insertedFrom.getOpposite().getNormal()).scale((double)(0.5f - offset));
        ms.translate(offsetVec.x, offsetVec.y, offsetVec.z);
        boolean bl = alongX = insertedFrom.getClockWise().getAxis() == Direction.Axis.X;
        if (!alongX) {
            sideOffset *= -1.0f;
        }
        ms.translate(alongX ? sideOffset : 0.0f, 0.0f, alongX ? 0.0f : sideOffset);
        ItemStack itemStack = transported.stack;
        Random r = new Random(0L);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        int count = Mth.log2((int)itemStack.getCount()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright((ItemStack)itemStack);
        BakedModel bakedModel = itemRenderer.getModel(itemStack, null, null, 0);
        boolean blockItem = bakedModel.isGui3d();
        if (renderUpright) {
            ms.translate(0.0, 0.09375, 0.0);
        }
        if (packages = itemStack.is(AllTags.AllItemTags.PACKAGES.tag)) {
            ms.translate(0.0f, 0.125f, 0.0f);
            ms.scale(4.0f, 4.0f, 4.0f);
        }
        int positive = insertedFrom.getAxisDirection().getStep();
        float verticalAngle = (float)positive * offset * 360.0f;
        if (insertedFrom.getAxis() != Direction.Axis.X) {
            msr.rotateXDegrees(verticalAngle);
        }
        if (insertedFrom.getAxis() != Direction.Axis.Z) {
            msr.rotateZDegrees(-verticalAngle);
        }
        if (renderUpright) {
            Entity renderViewEntity = Minecraft.getInstance().cameraEntity;
            if (renderViewEntity != null) {
                Vec3 positionVec = renderViewEntity.position();
                Vec3 vectorForOffset = itemPosition.add(offsetVec);
                Vec3 diff = vectorForOffset.subtract(positionVec);
                if (insertedFrom.getAxis() != Direction.Axis.X) {
                    diff = VecHelper.rotate((Vec3)diff, (double)verticalAngle, (Direction.Axis)Direction.Axis.X);
                }
                if (insertedFrom.getAxis() != Direction.Axis.Z) {
                    diff = VecHelper.rotate((Vec3)diff, (double)(-verticalAngle), (Direction.Axis)Direction.Axis.Z);
                }
                float yRot = (float)Mth.atan2((double)diff.z, (double)(-diff.x));
                ms.mulPose(Axis.YP.rotation((float)((double)yRot - 1.5707963267948966)));
            }
            ms.translate(0.0f, 0.0f, -0.0625f);
        }
        for (int i = 0; i <= count; ++i) {
            ms.pushPose();
            if (blockItem) {
                ms.translate(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            ms.scale(0.5f, 0.5f, 0.5f);
            if (!blockItem && !renderUpright) {
                msr.rotateXDegrees(90.0f);
            }
            if (packages) {
                ms.translate(0.0f, 0.125f, 0.0f);
            }
            itemRenderer.render(itemStack, ItemDisplayContext.FIXED, false, ms, buffer, light, overlay, bakedModel);
            ms.popPose();
            if (!renderUpright) {
                if (!blockItem) {
                    msr.rotateYDegrees(10.0f);
                }
                ms.translate(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.translate(0.0f, 0.0f, -0.0625f);
        }
        ms.popPose();
    }
}

