/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items.gatling_breaker;

import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.content.equipment.zapper.ZapperBeamPacket;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import dev.lopyluna.dndesires.content.items.gatling_breaker.GatlingBreakerRenderer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class GatlingBreakerItem
extends Item
implements CustomArmPoseItem {
    HolderLookup.RegistryLookup<Enchantment> enchantmentLookup = null;
    boolean shooting = false;
    int shotSpeed = 20;
    int tick = 0;
    int reloadTick = 0;

    public GatlingBreakerItem(Item.Properties properties) {
        super(properties.durability(2000).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.deniesDrops((TagKey)BlockTags.INCORRECT_FOR_NETHERITE_TOOL)), 1.0f, 1)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new GatlingBreakerRenderer()));
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(Items.NETHERITE_SCRAP) || super.isValidRepairItem(toRepair, repair);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!player.getCooldowns().isOnCooldown((Item)this)) {
            player.startUsingItem(usedHand);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.breakBlock(level, serverPlayer, player.getItemInHand(usedHand), usedHand, usedHand == InteractionHand.MAIN_HAND);
            }
        }
        return super.use(level, player, usedHand);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        ServerPlayer player;
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
        if (level.isClientSide) {
            return;
        }
        if (livingEntity instanceof ServerPlayer && !((player = (ServerPlayer)livingEntity) instanceof FakePlayer)) {
            boolean isMain;
            int speedEff = this.enchantmentLookup == null ? 1 : this.getSpeedEfficiency(stack) + 1;
            int max = 8 - speedEff;
            InteractionHand hand = livingEntity.getUsedItemHand();
            boolean bl = isMain = hand == InteractionHand.MAIN_HAND;
            if (!this.shooting) {
                this.shooting = true;
                this.reloadTick = 0;
            }
            if (this.tick >= this.shotSpeed) {
                this.breakBlock(level, player, stack, hand, isMain);
                if (this.shotSpeed > max) {
                    this.shotSpeed -= speedEff;
                }
                if (this.shotSpeed < max) {
                    this.shotSpeed = max;
                }
                this.tick = 0;
            }
            ++this.tick;
        }
    }

    public int getSpeedEfficiency(ItemStack stack) {
        return stack.getEnchantmentLevel((Holder)this.enchantmentLookup.getOrThrow(Enchantments.EFFICIENCY));
    }

    public void breakBlock(Level level, ServerPlayer player, ItemStack stack, InteractionHand hand, boolean isMain) {
        Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 range = player.getLookAngle().scale((double)this.getDefaultRange());
        BlockHitResult raytrace = level.clip(new ClipContext(start, start.add(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (boolean)isMain, (Vec3)new Vec3((double)0.35f, (double)-0.1f, 1.0));
        ShootableGadgetItemMethods.sendPackets((Player)player, b -> new ZapperBeamPacket(barrelPos, hand, b.booleanValue(), raytrace.getLocation()));
        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        BlockPos pos = raytrace.getBlockPos();
        BlockState stateReplaced = level.getBlockState(pos);
        float hardness = stateReplaced.getDestroySpeed((BlockGetter)level, pos);
        if (stateReplaced.isAir() || !level.isInWorldBounds(pos) || hardness == -1.0f || hardness > 50.0f) {
            return;
        }
        level.destroyBlock(pos, false);
        if (!stateReplaced.requiresCorrectToolForDrops() || !stateReplaced.is(BlockTags.INCORRECT_FOR_NETHERITE_TOOL)) {
            Block.dropResources((BlockState)stateReplaced, (Level)level, (BlockPos)player.blockPosition(), (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack);
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        super.releaseUsing(stack, level, livingEntity, timeCharged);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        this.tick = 0;
        this.shooting = false;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ServerPlayer player;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide) {
            return;
        }
        if (this.enchantmentLookup == null) {
            this.enchantmentLookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        }
        if (entity instanceof ServerPlayer && !((player = (ServerPlayer)entity) instanceof FakePlayer) && !this.shooting && 20 > this.shotSpeed) {
            if (this.reloadTick >= this.shotSpeed) {
                ++this.shotSpeed;
                this.reloadTick = 0;
            }
            ++this.reloadTick;
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public int getDefaultRange() {
        return 15;
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 15;
    }
}

