/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class AbstractModelProvider
implements DataProvider {
    public static final String BLOCK_PATH = "block";
    public static final String ITEM_PATH = "item";
    public static final ModelTemplate SPAWN_EGG = ModelTemplates.createItem((String)"template_spawn_egg", (TextureSlot[])new TextureSlot[0]);
    private final String modId;
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    private final Set<Object> skipValidation = Sets.newHashSet();

    public AbstractModelProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractModelProvider(String modId, PackOutput packOutput) {
        this.modId = modId;
        this.blockStatePathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.modelPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
    }

    public void addBlockModels(BlockModelGenerators builder) {
    }

    public void addItemModels(ItemModelGenerators builder) {
    }

    protected boolean skipValidation() {
        return false;
    }

    protected void skipBlock(Block block) {
        this.skipValidation.add(block);
    }

    protected void skipItem(Item item) {
        this.skipValidation.add(item);
    }

    public CompletableFuture<?> run(CachedOutput output) {
        HashMap generators = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = generator -> {
            Block block = generator.getBlock();
            BlockStateGenerator blockstategenerator = generators.put(block, generator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate block state definition for " + String.valueOf(block));
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier> modelOutput = (resourceLocation, supplier) -> {
            if (models.put(resourceLocation, supplier) != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        this.addBlockModels(new BlockModelGenerators(blockStateOutput, modelOutput, skippedAutoModels::add));
        this.addItemModels(new ItemModelGenerators(modelOutput));
        List<Object> missingBlocks = !this.skipValidation() ? BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals(this.modId) && !generators.containsKey(entry.getValue())).map(Map.Entry::getValue).filter(Predicate.not(this.skipValidation::contains)).toList() : Collections.emptyList();
        if (!missingBlocks.isEmpty()) {
            throw new IllegalStateException("Missing block state definitions for " + String.valueOf(missingBlocks));
        }
        BuiltInRegistries.BLOCK.entrySet().forEach(entry -> {
            Item item = (Item)Item.BY_BLOCK.get(entry.getValue());
            if (item != null) {
                if (!((ResourceKey)entry.getKey()).location().getNamespace().equals(this.modId) || skippedAutoModels.contains(item)) {
                    return;
                }
                ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation((Item)item);
                if (!models.containsKey(resourcelocation)) {
                    models.put(resourcelocation, new DelegatedModel(ModelLocationUtils.getModelLocation((Block)((Block)entry.getValue()))));
                }
            }
        });
        List<Object> missingItems = !this.skipValidation() ? BuiltInRegistries.ITEM.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals(this.modId) && !models.containsKey(AbstractModelProvider.decorateItemModelLocation(((ResourceKey)entry.getKey()).location()))).map(Map.Entry::getValue).filter(Predicate.not(this.skipValidation::contains)).toList() : Collections.emptyList();
        if (!missingItems.isEmpty()) {
            throw new IllegalStateException("Missing item models for " + String.valueOf(missingItems));
        }
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = AbstractModelProvider.saveCollection(output, generators, block -> this.blockStatePathProvider.json(block.builtInRegistryHolder().key().location()));
        completableFutureArray[1] = AbstractModelProvider.saveCollection(output, models, arg_0 -> ((PackOutput.PathProvider)this.modelPathProvider).json(arg_0));
        return CompletableFuture.allOf(completableFutureArray);
    }

    public final String getName() {
        return "Model Definitions";
    }

    private static <T> CompletableFuture<?> saveCollection(CachedOutput output, Map<T, ? extends Supplier<JsonElement>> map, Function<T, Path> pathExtractor) {
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            Path path = (Path)pathExtractor.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)((Supplier)entry.getValue()).get();
            return DataProvider.saveStable((CachedOutput)output, (JsonElement)jsonElement, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public static ResourceLocation getModelLocation(Block block) {
        return AbstractModelProvider.decorateBlockModelLocation(AbstractModelProvider.getLocation(block));
    }

    public static ResourceLocation decorateBlockModelLocation(ResourceLocation resourceLocation) {
        return resourceLocation.withPrefix("block/");
    }

    public static ResourceLocation getLocation(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static String getName(Block block) {
        return AbstractModelProvider.getLocation(block).getPath();
    }

    public static ResourceLocation getModelLocation(Item item) {
        return AbstractModelProvider.decorateItemModelLocation(AbstractModelProvider.getLocation(item));
    }

    public static ResourceLocation decorateItemModelLocation(ResourceLocation resourceLocation) {
        return resourceLocation.withPrefix("item/");
    }

    public static ResourceLocation getLocation(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static String getName(Item item) {
        return AbstractModelProvider.getLocation(item).getPath();
    }

    public static ResourceLocation stripUntil(ResourceLocation resourceLocation, String s) {
        String path = resourceLocation.getPath();
        if (path.contains(s)) {
            path = path.substring(path.lastIndexOf(s) + 1);
            return ResourceLocationHelper.fromNamespaceAndPath(resourceLocation.getNamespace(), path);
        }
        return resourceLocation;
    }

    public static ModelTemplate createBlockModelTemplate(ResourceLocation blockModelLocation, TextureSlot ... requiredSlots) {
        return AbstractModelProvider.createBlockModelTemplate(blockModelLocation, "", requiredSlots);
    }

    public static ModelTemplate createBlockModelTemplate(ResourceLocation blockModelLocation, String suffix, TextureSlot ... requiredSlots) {
        return new ModelTemplate(Optional.of(AbstractModelProvider.decorateBlockModelLocation(blockModelLocation)), Optional.of(suffix), requiredSlots);
    }

    public static ModelTemplate createItemModelTemplate(ResourceLocation itemModelLocation, TextureSlot ... requiredSlots) {
        return AbstractModelProvider.createItemModelTemplate(itemModelLocation, "", requiredSlots);
    }

    public static ModelTemplate createItemModelTemplate(ResourceLocation itemModelLocation, String suffix, TextureSlot ... requiredSlots) {
        return new ModelTemplate(Optional.of(AbstractModelProvider.decorateItemModelLocation(itemModelLocation)), Optional.of(suffix), requiredSlots);
    }

    public static ResourceLocation generateFlatItem(ResourceLocation resourceLocation, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        return modelTemplate.create(AbstractModelProvider.decorateItemModelLocation(resourceLocation), TextureMapping.layer0((ResourceLocation)AbstractModelProvider.decorateItemModelLocation(resourceLocation)), modelOutput);
    }

    public static ResourceLocation generateFlatItem(Item item, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, ModelTemplate.JsonFactory factory) {
        return modelTemplate.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Item)item), modelOutput, factory);
    }
}

