/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.client.core.context.BlockRenderTypesContextImpl;
import fuzs.puzzleslib.impl.client.core.context.FluidRenderTypesContextImpl;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.client.core.context.AdditionalModelsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.BlockColorProvidersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.BlockEntityRenderersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.BuiltinModelItemRendererContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.ClientTooltipComponentsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.CoreShadersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.EntityRenderersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.EntitySpectatorShaderContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.ItemColorProvidersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.ItemDecorationContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.ItemModelPropertiesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.KeyMappingsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.LayerDefinitionsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.LivingEntityRenderLayersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.MenuScreensContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.ParticleProvidersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.RenderBuffersContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.ResourcePackSourcesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.client.core.context.SkullRenderersContextNeoForgeImpl;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;

public final class NeoForgeClientModConstructor {
    private NeoForgeClientModConstructor() {
    }

    public static void construct(ClientModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> {
            NeoForgeClientModConstructor.registerLoadingHandlers(constructor, modId, eventBus, availableFlags, flagsToHandle);
            constructor.onConstructMod();
        });
    }

    private static void registerLoadingHandlers(ClientModConstructor constructor, String modId, IEventBus eventBus, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        ArrayList dynamicRenderers = new ArrayList();
        eventBus.addListener(evt -> evt.enqueueWork(() -> {
            constructor.onClientSetup();
            constructor.onRegisterItemModelProperties(new ItemModelPropertiesContextNeoForgeImpl());
            constructor.onRegisterBlockRenderTypes(new BlockRenderTypesContextImpl());
            constructor.onRegisterFluidRenderTypes(new FluidRenderTypesContextImpl());
        }));
        eventBus.addListener(evt -> constructor.onRegisterMenuScreens(new MenuScreensContextNeoForgeImpl((RegisterMenuScreensEvent)evt)));
        eventBus.addListener(evt -> {
            constructor.onRegisterEntityRenderers(new EntityRenderersContextNeoForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1)));
            constructor.onRegisterBlockEntityRenderers(new BlockEntityRenderersContextNeoForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerBlockEntityRenderer(arg_0, arg_1)));
        });
        eventBus.addListener(evt -> constructor.onRegisterClientTooltipComponents(new ClientTooltipComponentsContextNeoForgeImpl((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterParticleProviders(new ParticleProvidersContextNeoForgeImpl((RegisterParticleProvidersEvent)evt)));
        eventBus.addListener(evt -> constructor.onRegisterLayerDefinitions(new LayerDefinitionsContextNeoForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)evt).registerLayerDefinition(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterAdditionalModels(new AdditionalModelsContextNeoForgeImpl(arg_0 -> ((ModelEvent.RegisterAdditional)evt).register(arg_0))));
        eventBus.addListener(evt -> constructor.onRegisterItemDecorations(new ItemDecorationContextNeoForgeImpl((arg_0, arg_1) -> ((RegisterItemDecorationsEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterEntitySpectatorShaders(new EntitySpectatorShaderContextNeoForgeImpl((arg_0, arg_1) -> ((RegisterEntitySpectatorShadersEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterSkullRenderers(new SkullRenderersContextNeoForgeImpl(evt.getEntityModelSet(), (arg_0, arg_1) -> ((EntityRenderersEvent.CreateSkullModels)evt).registerSkullModel(arg_0, arg_1))));
        eventBus.addListener(evt -> {
            if (availableFlags.contains((Object)ContentRegistrationFlags.DYNAMIC_RENDERERS)) {
                evt.registerReloadListener(ForwardingReloadListenerHelper.fromResourceManagerReloadListeners(ResourceLocationHelper.fromNamespaceAndPath(modId, "built_in_model_item_renderers"), dynamicRenderers));
            }
        });
        eventBus.addListener(evt -> constructor.onRegisterLivingEntityRenderLayers(new LivingEntityRenderLayersContextNeoForgeImpl((EntityRenderersEvent.AddLayers)evt)));
        eventBus.addListener(evt -> constructor.onRegisterKeyMappings(new KeyMappingsContextNeoForgeImpl(arg_0 -> ((RegisterKeyMappingsEvent)evt).register(arg_0))));
        eventBus.addListener(evt -> constructor.onRegisterBlockColorProviders(new BlockColorProvidersContextNeoForgeImpl((x$0, xva$1) -> evt.register(x$0, new Block[]{xva$1}), evt.getBlockColors())));
        eventBus.addListener(evt -> constructor.onRegisterItemColorProviders(new ItemColorProvidersContextNeoForgeImpl((x$0, xva$1) -> evt.register(x$0, new ItemLike[]{xva$1}), evt.getItemColors())));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.CLIENT_RESOURCES) {
                constructor.onAddResourcePackFinders(new ResourcePackSourcesContextNeoForgeImpl((AddPackFindersEvent)evt));
            }
        });
        eventBus.addListener(evt -> constructor.onRegisterCoreShaders(new CoreShadersContextNeoForgeImpl((arg_0, arg_1) -> ((RegisterShadersEvent)evt).registerShader(arg_0, arg_1), evt.getResourceProvider())));
        eventBus.addListener(evt -> constructor.onRegisterRenderBuffers(new RenderBuffersContextNeoForgeImpl((arg_0, arg_1) -> ((RegisterRenderBuffersEvent)evt).registerRenderBuffer(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterBuiltinModelItemRenderers(new BuiltinModelItemRendererContextNeoForgeImpl((x$0, xva$1) -> evt.registerItem(x$0, new Item[]{xva$1}), modId, dynamicRenderers)));
    }
}

