/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.init;

import com.google.common.base.Function;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.impl.client.init.ItemDisplayOverridesImpl;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.BakedModelWrapper;

public final class NeoForgeItemDisplayOverrides
extends ItemDisplayOverridesImpl<BakedModelKey> {
    @Override
    public void register(ModelResourceLocation itemModel, ModelResourceLocation itemModelOverride, ItemDisplayContext ... itemDisplayContexts) {
        Objects.requireNonNull(itemModelOverride, "item model override is null");
        this.register(itemModel, (Function<ItemDisplayOverridesImpl.BakedModelResolver, BakedModel>)((Function)modelResolver -> modelResolver.getModel(itemModelOverride)), itemDisplayContexts);
    }

    @Override
    public void register(ModelResourceLocation itemModel, ResourceLocation itemModelOverride, ItemDisplayContext ... itemDisplayContexts) {
        Objects.requireNonNull(itemModelOverride, "item model override is null");
        this.register(itemModel, (Function<ItemDisplayOverridesImpl.BakedModelResolver, BakedModel>)((Function)modelResolver -> modelResolver.getModel(ModelResourceLocation.standalone((ResourceLocation)itemModelOverride))), itemDisplayContexts);
    }

    @Override
    protected BakedModelKey createOverrideModelKey(ModelResourceLocation modelResourceLocation, BakedModel itemModel) {
        return new BakedModelKey(modelResourceLocation, itemModel);
    }

    @Override
    protected void registerEventHandlers() {
        NeoForgeModContainerHelper.getOptionalModEventBus("puzzleslib").ifPresent(eventBus -> eventBus.addListener(evt -> {
            BakedModel missingModel = (BakedModel)evt.getModels().get(ModelBakery.MISSING_MODEL_VARIANT);
            Objects.requireNonNull(missingModel, "missing model is null");
            Map overrideModels = this.computeOverrideModels(new ItemDisplayOverridesImpl.BakedModelResolver(){
                final /* synthetic */ ModelEvent.ModifyBakingResult val$evt;
                final /* synthetic */ BakedModel val$missingModel;
                {
                    this.val$evt = modifyBakingResult;
                    this.val$missingModel = bakedModel;
                }

                @Override
                public BakedModel getModel(ModelResourceLocation modelResourceLocation) {
                    return this.val$evt.getModels().getOrDefault(modelResourceLocation, this.val$missingModel);
                }

                @Override
                public BakedModel getModel(ResourceLocation resourceLocation) {
                    return this.val$evt.getModels().getOrDefault(ModelResourceLocation.standalone((ResourceLocation)resourceLocation), this.val$missingModel);
                }
            }, missingModel);
            for (final Map.Entry entry : overrideModels.entrySet()) {
                evt.getModels().put(((BakedModelKey)entry.getKey()).modelResourceLocation(), new BakedModelWrapper<BakedModel>(this, ((BakedModelKey)entry.getKey()).bakedModel()){

                    public BakedModel applyTransform(ItemDisplayContext itemDisplayContext, PoseStack poseStack, boolean applyLeftHandTransform) {
                        return ((Map)entry.getValue()).getOrDefault(itemDisplayContext, this.originalModel).applyTransform(itemDisplayContext, poseStack, applyLeftHandTransform);
                    }
                });
            }
        }));
    }

    protected record BakedModelKey(ModelResourceLocation modelResourceLocation, BakedModel bakedModel) {
    }
}

