/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.screens;

import com.teamresourceful.resourcefullib.client.components.CursorWidget;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;

public interface CursorScreen {
    public void setCursor(Cursor var1);

    default public void setCursor(List<? extends GuiEventListener> listeners, double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : listeners) {
            boolean hovered = guiEventListener.isMouseOver(mouseX, mouseY);
            if (guiEventListener instanceof CursorWidget) {
                CursorWidget widget = (CursorWidget)guiEventListener;
                if (hovered) {
                    this.setCursor(widget.getCursor());
                    break;
                }
            }
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (!hovered || !widget.visible) continue;
            if (widget.active) {
                this.setCursor(widget instanceof EditBox || widget instanceof MultiLineEditBox ? Cursor.TEXT : Cursor.POINTER);
                break;
            }
            this.setCursor(Cursor.DISABLED);
            break;
        }
    }

    public static enum Cursor {
        DEFAULT,
        POINTER,
        DISABLED,
        TEXT,
        CROSSHAIR,
        RESIZE_EW,
        RESIZE_NS,
        RESIZE_NWSE,
        RESIZE_NESW,
        RESIZE_ALL;

    }
}

