/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.bytecodecs;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;

public final class CompoundTagByteCodec
implements ByteCodec<Optional<CompoundTag>> {
    public static final CompoundTagByteCodec INSTANCE = new CompoundTagByteCodec();

    public void encode(Optional<CompoundTag> value, ByteBuf buffer) {
        if (value.isEmpty()) {
            buffer.writeByte(0);
        } else {
            try {
                NbtIo.write((CompoundTag)value.get(), (DataOutput)new ByteBufOutputStream(buffer));
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public Optional<CompoundTag> decode(ByteBuf buffer) {
        int i = buffer.readerIndex();
        byte b = buffer.readByte();
        if (b == 0) {
            return Optional.empty();
        }
        buffer.readerIndex(i);
        try {
            return Optional.of(NbtIo.read((DataInput)new ByteBufInputStream(buffer), (NbtAccounter)NbtAccounter.create((long)0x200000L)));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

